% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_slope.R
\name{get_slope}
\alias{get_slope}
\title{Calculate a slope}
\usage{
get_slope(x, neighbourhood = matrix(4))
}
\arguments{
\item{x}{A matrix}

\item{neighbourhood}{The number of directions in which cell adjacencies are
considered as neighbours: 4 (rook's case), 8 (queen's case) or a binary matrix
where the ones define the neighbourhood. The default is 4.}
}
\value{
A slope value
}
\description{
Calculate a slope
}
\details{
"Slope" is calculated as follows:
\enumerate{
\item For each cell, the algorithm looks at its 4 neighbors and
calculates the absolute difference between the main cell and its neighbors.
\item Next, it sums these four values.
\item After repeating this operation for every cell, it calculates
an average of the sum of the absolute differences for the whole raster.
}
}
