% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_ls.R
\name{bfa_ls}
\alias{bfa_ls}
\title{Least Squares Estimation of Bifurcating Autoregressive Models}
\usage{
bfa_ls(
  z,
  p,
  x_data = FALSE,
  y_data = FALSE,
  resids = FALSE,
  error_cor = TRUE,
  error_var = FALSE,
  cov_matrix = FALSE,
  conf = FALSE,
  conf_level = 0.95,
  B = 49,
  p_value = FALSE
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{x_data}{a logical that determines whether the x data used in fitting
the model should be returned. Defaults to FALSE.}

\item{y_data}{a logical that determines whether the y data used in fitting
the model should be returned. Defaults to FALSE.}

\item{resids}{a logical that determines whether the model residuals should be
returned. Defaults to FALSE.}

\item{error_cor}{a logical that determines whether the estimated correlation
between pairs of model errors \eqn{(e_{2t}, e_{2t+1})} should be returned.
Defaults to TRUE.}

\item{error_var}{a logical that determines whether the estimated variance of
the model errors should be returned. Defaults to FALSE.}

\item{cov_matrix}{a logical that determines whether the estimated
variance-covariance matrix of the least squares estimates should be
returned. Defaults to FALSE.}

\item{conf}{a logical that determines whether confidence intervals for model
coefficients should be returned. Defaults to FALSE. If TRUE, asymptotic normal
confidence intervals for the intercept and the slops are calculated using
\code{cov_matrix}. In addition, normal bootstrap confidence interval, and
percentile confidence interval for the slop are calculated.}

\item{conf_level}{confidence level to be used in computing the normal
confidence intervals for model coefficients when \code{conf=TRUE}. Defaults
to \code{0.95}.}

\item{B}{number of bootstrap samples (replicates)}

\item{p_value}{a logical that determines whether p-values for model
coefficients should be returned. Defaults to FALSE. If TRUE, p-values are
computed from normal distribution using estimated coefficients and
\code{cov_matrix}.}
}
\value{
\item{coef}{a matrix containing the least squares estimates of the
autoregressive coefficients} \item{error_cor}{the least squares estimate of
the correlation between pairs of model errors \eqn{(e_{2t}, e_{2t+1})}.
Only returned if \code{error_cor=TRUE}} \item{x}{a matrix containing the x
data used in fitting the model. Only returned if \code{x_data=TRUE}}
\item{y}{a vector containing the y data used in fitting the model. Only
returned if \code{y_data=TRUE}} \item{resids}{the model residuals. Only
returned if \code{resids=TRUE}} \item{error_var}{the estimated variance of
the model errors. Only returned if \code{error_var=TRUE}}
\item{cov_matrix}{the estimated variance-covariance matrix of the least
squares coefficients. Only returned if \code{cov_matrix=TRUE}}\item{conf}{a
matrix of normal confidence intervals for model coefficients. Only returned
if \code{conf=TRUE}}\item{p_value}{a matrix of two-sided p-values for
testing the significance of model coefficients. Computed from normal
distribution and using the estimated covariance matrix \code{cov_matrix}.
Only returned if \code{p_value=TRUE}}
}
\description{
This function performs Least Squares estimation of bifurcating autoregressive
(BFA) models of any order as described in Zhou and Basawa (2005).
}
\examples{
z <- bfa_tree_gen(127, 1, 1, 1, -0.9, -0.9, 0, 10, c(0.7))
bfa_ls(z, p=1)
bfa_ls(z,p=1,conf=TRUE,cov_matrix = TRUE,conf_level = 0.9,p_value=TRUE)
}
\references{
Zhou, J. & Basawa, I. V. (2005). Least squares estimation for
bifurcating autoregressive processes. \emph{Statistics & Probability
Letters}, 74(1):77-88.
}
