% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{svd_robust}
\alias{svd_robust}
\title{Robust singular value decomposition (C++ backend)}
\usage{
svd_robust(
  x,
  ncomp,
  max_iter = 25L,
  tol = sqrt(.Machine$double.eps),
  huber_k = 1.345
)
}
\arguments{
\item{x}{Numeric matrix for which the decomposition should be computed.}

\item{ncomp}{Number of leading components to retain.}

\item{max_iter}{Maximum number of reweighting iterations.}

\item{tol}{Convergence tolerance applied to successive changes in the row
weights and singular values.}

\item{huber_k}{Tuning constant controlling the aggressiveness of the Huber
weight function. Larger values down-weight fewer observations.}
}
\value{
A list containing the left and right singular vectors (\code{u} and \code{v}),
the singular values (\code{d}), the final row weights (\code{weights}), and the number
of iterations required for convergence (\code{iterations}).
}
\description{
Compute the iteratively reweighted SVD using the high-performance C++
implementation. The interface mirrors \code{\link[=svd_robust_R]{svd_robust_R()}} while delegating the
heavy lifting to compiled code.
}
