% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landmark_mds.R
\name{landmark_mds}
\alias{landmark_mds}
\title{Landmark MDS}
\usage{
landmark_mds(x, num_landmarks, r)
}
\arguments{
\item{x}{A matrix with \eqn{n} points (rows) and \eqn{k} variables (columns).}

\item{num_landmarks}{Number of landmark points to obtain an initial MDS configuration. It is
equivalent to \code{l} parameter used in \code{\link[=interpolation_mds]{interpolation_mds()}}, \code{\link[=divide_conquer_mds]{divide_conquer_mds()}} and
\code{\link[=fast_mds]{fast_mds()}}. Therefore, it is the size for which classical MDS can be computed efficiently
(using \code{cmdscale} function). It means that if \eqn{\bar{l}} is the limit
size for which classical MDS is applicable, then \code{l}\eqn{\leq \bar{l}}.}

\item{r}{Number of principal coordinates to be extracted.}
}
\value{
Returns a list containing the following elements:
\describe{
\item{points}{A matrix that consists of \eqn{n} points (rows)
and \code{r} variables (columns) corresponding to the principal coordinates. Since
a dimensionality reduction is performed, \code{r}\eqn{<<k}}
\item{eigen}{The first \code{r} largest eigenvalues:
\eqn{\lambda_i, i \in  \{1, \dots, r\} }, where each \eqn{\lambda_i} is obtained
from applying classical MDS to the first data subset.}
}
}
\description{
Landmark MDS (LMDS) algorithm applies first classical MDS to a
subset of the data (\emph{landmark points}) and then the remaining individuals are
projected onto the landmark low dimensional configuration using a
distance-based triangulation procedure.
}
\details{
LMDS applies first classical MDS to a subset of the data (\emph{landmark points}). Then,
it uses a distance-based triangulation procedure to project the non-landmark individuals. This
distance-based triangulation procedure coincides with  \emph{Gower's interpolation formula}.

This method is similar to \code{\link[=interpolation_mds]{interpolation_mds()}} and \code{\link[=reduced_mds]{reduced_mds()}}.
}
\examples{
set.seed(42)
x <- matrix(data = rnorm(4 * 10000), nrow = 10000) \%*\% diag(c(9, 4, 1, 1))
mds <- landmark_mds(x = x, num_landmarks = 200, r = 2)
head(mds$points)
mds$eigen

}
\references{
Delicado P. and C. Pachón-García (2021). \emph{Multidimensional Scaling for Big Data}.
\url{https://arxiv.org/abs/2007.11919}.

Borg, I. and P. Groenen (2005). \emph{Modern Multidimensional Scaling: Theory and Applications}. Springer.

De Silva V. and JB. Tenenbaum (2004). \emph{Sparse multidimensional scaling using landmark points}. Technical Report, Stanford University.

Gower JC. (1968). \emph{Adding a point to vector diagrams in multivariate analysis}. Biometrika.
}
