% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_mds.R
\name{pivot_mds}
\alias{pivot_mds}
\title{Pivot MDS}
\usage{
pivot_mds(x, num_pivots, r)
}
\arguments{
\item{x}{A matrix with \eqn{n} individuals (rows) and \eqn{k} variables (columns).}

\item{num_pivots}{Number of pivot points to obtain an initial MDS configuration. It is
equivalent to \code{l} parameter used in \code{\link[=interpolation_mds]{interpolation_mds()}}, \code{\link[=divide_conquer_mds]{divide_conquer_mds()}} and
\code{\link[=fast_mds]{fast_mds()}}. Therefore, it is the size for which classical MDS can be computed efficiently
(using \code{cmdscale} function). It means that if \eqn{\bar{l}} is the limit
size for which classical MDS is applicable, then \code{l}\eqn{\leq \bar{l}}.}

\item{r}{Number of principal coordinates to be extracted.}
}
\value{
Returns a list containing the following elements:
\describe{
\item{points}{A matrix that consists of \eqn{n} individuals (rows)
and \code{r} variables (columns) corresponding to the principal coordinates. Since
we are performing a dimensionality reduction, \code{r}\eqn{<<k}}
\item{eigen}{The first \code{r} largest eigenvalues:
\eqn{\lambda_i, i \in  \{1, \dots, r\} }, where each \eqn{\lambda_i} is obtained
from applying classical MDS to the first data subset.}
}
}
\description{
Pivot MDS, introduced in the literature of graph layout algorithms, is similar to
Landmark MDS (\code{\link[=landmark_mds]{landmark_mds()}}) but it uses the distance information between landmark and non-landmark
points to improve the initial low dimensional configuration,
as more relations than just those between landmark points are taken into account.
}
\examples{
set.seed(42)
x <- matrix(data = rnorm(4 * 10000), nrow = 10000) \%*\% diag(c(9, 4, 1, 1))
mds <- pivot_mds(x = x, num_pivots = 200, r = 2)
head(mds$points)
mds$eigen

}
\references{
Delicado P. and C. Pachón-García (2021). \emph{Multidimensional Scaling for Big Data}.
\url{https://arxiv.org/abs/2007.11919}.

Brandes U. and C. Pich (2007). \emph{Eigensolver Methods for Progressive Multidimensional Scaling of Large Data}. Graph Drawing.

Borg, I. and P. Groenen (2005). \emph{Modern Multidimensional Scaling: Theory and Applications}. Springer.

Gower JC. (1968). \emph{Adding a point to vector diagrams in multivariate analysis}. Biometrika.
}
