% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_criteria.R
\name{get_ic_vals.bigtime.VAR}
\alias{get_ic_vals.bigtime.VAR}
\title{Calculates the Information Criteria for a model estimated using
\code{\link{sparseVAR}}}
\usage{
\method{get_ic_vals}{bigtime.VAR}(mod, verbose = TRUE)
}
\arguments{
\item{mod}{Model estimated using \code{\link{sparseVAR}}}

\item{verbose}{Should information about the optimal selection be printed?}
}
\value{
Returns a list containing
\item{ics}{Values of the ICs for all lambdas}
\item{mins}{Which IC lead to the minimum (the row number)}
\item{selected_lambdas}{Which lambdas were selected}
}
\description{
The number of non-zero coefficients are taken as the degrees of freedom.
}
\examples{
dat <- simVAR(periods = 200, k=2, p=5, decay = 0.01)
mod <- sparseVAR(Y=scale(dat$Y))
ics <- get_ic_vals(mod)
}
