# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

glasso <- function(mat, lambda, maxiter_outer, maxiter_lasso, tol, verbose) {
    .Call(`_bigutilsr_glasso`, mat, lambda, maxiter_outer, maxiter_lasso, tol, verbose)
}

#' Solve (A + lam I) x = b
#'
#' @param A A *symmetric* square matrix.
#' @param b A vector.
#' @param add_to_diag One value to add to the diagonal of A (lam). Default is 0.
#'
#' @return The best solution `x` of this linear system.
#'
#' @examples
#' A <- matrix(rnorm(4), 2); A[1, 2] <- A[2, 1]  # should be symmetric
#' x <- rnorm(2)
#' b <- A %*% x
#' x2 <- drop(solve(A, b))
#' x3 <- solve_linear_system(A, b)
#' rbind(x, x2, x3)
#'
#' @export
solve_linear_system <- function(A, b, add_to_diag = 0) {
    .Call(`_bigutilsr_solve_linear_system`, A, b, add_to_diag)
}

sum_in_temp <- function(x, y, tmp_vec) {
    .Call(`_bigutilsr_sum_in_temp`, x, y, tmp_vec)
}

sub_in_temp <- function(x, y, tmp_vec) {
    .Call(`_bigutilsr_sub_in_temp`, x, y, tmp_vec)
}

scaleTau2_vector_rcpp <- function(x, tmp_dev, tmp_med) {
    .Call(`_bigutilsr_scaleTau2_vector_rcpp`, x, tmp_dev, tmp_med)
}

dist_scaleTau2_matrix_rcpp <- function(Z) {
    .Call(`_bigutilsr_dist_scaleTau2_matrix_rcpp`, Z)
}

roll_mean <- function(x, w) {
    .Call(`_bigutilsr_roll_mean`, x, w)
}

rowSumsSq <- function(source) {
    .Call(`_bigutilsr_rowSumsSq`, source)
}

