% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mleB2B.R
\name{mleB2B}
\alias{mleB2B}
\title{mleB2B  Estimates Back-to-Back "Q" and Offsets to a bit error rate function.}
\usage{
mleB2B(data = NULL, Errors, N, f, fparms, start, method = "Nelder-Mead", ...)
}
\arguments{
\item{data}{a data frame or list with named components. If a list, each
component must be the same length (just like a data frame). This is not
checked, so usual rules of recycling will apply.  Partial matching not
performed, so you must use full column names.}

\item{Errors}{A vector of error counts, or a string identifying a column of
\code{data} from which to draw the error counts}

\item{N}{A single number, or a vector of the same length as
\code{data}, or a string identifying a column of \code{data} specifying the number
of trials used to measure the error counts
in \code{Errors}.  If a single number, then that number is used as the number
of trials for all error counts.}

\item{f}{A function that predicts the probability of errors.}

\item{fparms}{a list of named components that are the arguments of \code{f}.
Each component can be a string, a single number, or a vector. If a
string that names a column of \code{data}, that column will be used,
otherwise the string will be passed to \code{f}.  Note the potential for
errors if a column name was misspelled. A single number or vector
will be passed to \code{f}. Between \code{fparms}, \code{start}, and function defaults,
all parameters that need to be supplied to \code{f} should be specified, and
(except for defaults) not duplicated.}

\item{start}{Named list of initial values for the parameters of \code{f} to be
estimated.}

\item{method}{Optimization method.  See \code{\link[stats:optim]{stats::optim()}}.}

\item{...}{Optional arguments to be passed to \link{mle}.}
}
\value{
An object of class \link[stats4:mle-class]{stats4::mle} with the parameters
identified in \code{start} estimated.
}
\description{
Bit error counts modeled as independent binary decisions result in a
log-likelihood dependent on the bit error probability.  This function
inserts the supplied bit error probability function into the binomial
log-likelihood function, and passes that to \link[stats4:mle]{stats4::mle}, which ultimately
calls \link[stats:optim]{stats::optim}.  The function will optimize a binomial probability
of the form $r = N * P( x_1, x_2, ..., x_n, a_1, a_2, ... a_k)$, where the
$x_i$ are variables from \code{data}, and the $a_j$ are parameters to be
estimated.
}
\details{
The function estimates the parameters identified in \code{start} in the
constructed call to \code{f}. For a function \code{f} of the form
\code{fun( SNR, x2, x3, B2B, offset)}
A call of the form

\code{
mleB2B( data=df, Errors="r", N="trials", f=fun,
        fparm=list( SNR="s", x2=1, x3="noise"), start=list(B2B=1, offset=2))
}

will construct a call to \code{mle} of the form:

\code{
mle( minuslogl=ll, start=start, nobs=length( Errors), method=method)}

where the function \code{ll} is defined as

\code{
  ll <- function( a, b) -sum( dbinom( df$r, df$n,
                fun( SNR=df$s, x2=1, x3=df$noise, B2B=B2B, offset=offset),
                log=TRUE))
}
}
\examples{
QPSKdB.B2B <- B2BConvert( QPSKdB)
O1 <- 3
B1 <- 16
s <- 0:20
N <- 1000000
r <- rbinom( length( s), N, QPSKdB.B2B( s, B1, O1))
df <- data.frame( Errors=r, SNR=s, N=N)
llsb2 <- function( b2b, offset)
         -sum( dbinom( r, N, QPSKdB.B2B( s, b2b, offset), log=TRUE))
mle1 <- stats4::mle( llsb2, start=c( b2b=20, offset=0), nobs=length(s),
                     method="Nelder-Mead")
est1 <-  mleB2B( data=df, Errors="Errors", N=N, f=QPSKdB.B2B,
                 fparms=list( x="SNR"), start=c(b2b=20, offset=0))

}
\seealso{
\code{\link[stats4:mle]{stats4::mle()}}, \code{\link[stats:optim]{stats::optim()}}
}
