% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultAnalytics.R
\name{resultAnalytics}
\alias{resultAnalytics}
\title{Result Calculation and Summary}
\usage{
resultAnalytics(img, coordinates, unfiltered = NULL)
}
\arguments{
\item{img}{image (import by \code{\link[biopixR]{importImage}})}

\item{coordinates}{all filtered coordinates of the objects (x|y|value data frame)}

\item{unfiltered}{all coordinates from every object before applying filter functions}
}
\value{
list of 2 objects:
\itemize{
\item \code{summary}: A summary of all the objects in the image.
\item \code{detailed}: Detailed information about every single object.
}
}
\description{
This function summarizes the data obtained by previous functions:
\code{\link[biopixR]{objectDetection}}, \code{\link[biopixR]{proximityFilter}}
or \code{\link[biopixR]{sizeFilter}}. Extracts information like amount,
intensity, size and density of the objects present in the image.
}
\details{
The \code{\link[biopixR]{resultAnalytics}} function provides comprehensive
summary of objects detected in an image:
\enumerate{
\item \strong{Summary}
\itemize{
\item Generates a summary of all detected objects, including the total number of objects, their mean size, size standard deviation, mean intensity, intensity standard deviation, estimated rejected objects, and coverage.
}
\item \strong{Detailed Object Information}
\itemize{
\item Provides detailed information for each object, including size, mean intensity, intensity standard deviation, and coordinates.
}
}
}
\examples{
res_objectDetection <- objectDetection(beads,
                                       alpha = 1,
                                       sigma = 0)
res_sizeFilter <- sizeFilter(
  res_objectDetection$centers,
  res_objectDetection$coordinates,
  lowerlimit = 50, upperlimit = 150
  )
res_proximityFilter <- proximityFilter(
  res_sizeFilter$centers,
  res_objectDetection$coordinates,
  radius = "auto"
  )
res_resultAnalytics <- resultAnalytics(
  coordinates = res_proximityFilter$coordinates,
  unfiltered = res_objectDetection$coordinates,
  img = beads
  )
print(res_resultAnalytics$summary)
plot(beads)
with(
  res_objectDetection$centers,
  points(
    res_objectDetection$centers$mx,
    res_objectDetection$centers$my,
    col = "red",
    pch = 19
    )
  )
with(
  res_resultAnalytics$detailed,
  points(
    res_resultAnalytics$detailed$x,
    res_resultAnalytics$detailed$y,
    col = "darkgreen",
    pch = 19
    )
  )
}
\seealso{
\code{\link[=objectDetection]{objectDetection()}}, \code{\link[=sizeFilter]{sizeFilter()}}, \code{\link[=proximityFilter]{proximityFilter()}}
}
