% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpful.functions.R
\name{add.mcmc}
\alias{add.mcmc}
\title{Convenient function to add results (i.e. combine mcmc.list)}
\usage{
add.mcmc(x, y)
}
\arguments{
\item{x}{first result in a format of mcmc.list}

\item{y}{second result in a format of mcmc.list}
}
\description{
This is a convenient function to add results (i.e. combine mcmc.list). 
This can be useful when combining results obtained from multiple imputation
}
\examples{
ds <- generate_ipdma_example(type = "continuous")
ds2 <- generate_ipdma_example(type = "continuous")
ipd <- with(ds, ipdma.model.onestage(y = y, study = studyid, treat = treat, X = cbind(z1, z2), 
response = "normal", shrinkage = "none"))
ipd2 <- with(ds2, ipdma.model.onestage(y = y, study = studyid, treat = treat, X = cbind(z1, z2), 
response = "normal", shrinkage = "none"))
\donttest{
samples <- ipd.run(ipd, pars.save = c("beta", "gamma", "delta"), n.chains = 3, n.burnin = 500, 
n.iter = 5000)
samples2 <- ipd.run(ipd2, pars.save = c("beta", "gamma", "delta"), n.chains = 3, n.burnin = 500, 
n.iter = 5000)
combined <- add.mcmc(samples, samples2)
}

}
