% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iccfit.R
\name{iccfit}
\alias{iccfit}
\title{Item Characteristic Curve Fitting}
\usage{
iccfit(mdl)
}
\arguments{
\item{mdl}{1, 2, or 3 representing the number of the model parameters.}
}
\description{
Plots the item characteristic curve and the simulated observed proportions
of correct response from the one-, two-, or three-parameter logistic model.
}
\details{
While the theoretical range of ability is from negative infinity to positive
infinity, practical considerations usually limit the range of values
from -3 to +3.
With the number of item characteristic curve model parameters \code{mdl}
the item parameters are randomly sampled from the uniform distributions; for
example, under the three-parameter logistic model, \code{b} from the -3 to
3 range, \code{a} from the 0.2 to 2.8 range, and \code{c} from the 0 to
.35 range.
Each of the 33 ability levels from the -3 to +3 range with .1875 interval,
the observed proportion of correct response is generated from the binomial
distribution for sample size of 21.
The chi-square goodness-of-fit index is obtained and reported with the
set of item parameters.
}
\examples{
iccfit(1)
iccfit(2)
iccfit(3)
}
\references{
Baker, F. B., & Kim, S.-H. (2017).
\emph{The basics of item response theory using R.}
New York, NY: Springer.
ISBN-13: 978-3-319-54204-1
}
\keyword{iccfit}
