% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMGGUM.R
\name{bmggum}
\alias{bmggum}
\title{Bayesian Multidimensional Generalized Graded Unfolding Model (bmggum)}
\usage{
bmggum(
  GGUM.Data,
  delindex,
  trait,
  ind,
  option,
  model = "UM8",
  covariate = NULL,
  iter = 1000,
  chains = 3,
  warmup = floor(iter/2),
  adapt_delta = 0.9,
  max_treedepth = 15,
  init = "random",
  thin = 1,
  cores = 2,
  ma = 0,
  va = 0.5,
  mdne = -1,
  mdnu = 0,
  mdpo = 1,
  vd = 1,
  mt = seq(-3, 0, 3/(option - 1)),
  vt = 2
)
}
\arguments{
\item{GGUM.Data}{Response data in wide format}

\item{delindex}{A two-row data matrix: the first row is the item number (1, 2, 3, 4...); the second row indicates the signs of delta for each item (-1,0,1,...). For items that have negative deltas for sure, "-1" should be assigned; for items that have positive deltas, "1" should be assigned; for items whose deltas may be either positive or negative (e.g., intermediate items), "0" should assigned. We recommend at least two positive and two negative items per trait for better estimation.}

\item{trait}{The number of latent traits.}

\item{ind}{A row vector mapping each item to each trait. For example, c(1, 1, 1, 2, 2, 2) means that the first 3 items belong to trait 1 and the last 3 items belong to trait 2.}

\item{option}{The number of response options.}

\item{model}{Models fitted. They can be "UM8", "UM7", and "UM4". The default is UM8, which is the GGUM model. UM4 is UM8 with alpha = 1, called partial credit unfolding model. UM7 is UM8 with equal taus across items, called generalized rating scale unfolding model.}

\item{covariate}{An p*c person covariate matrix where p equals sample size and c equals the number of covariates. The default is NULL, meaning no person covariate.}

\item{iter}{The number of iterations. The default value is 1000. See documentation for rstan for more details.}

\item{chains}{The number of chains. The default value is 3. See documentation for rstan for more details.}

\item{warmup}{The number of warmups to discard. The default value is 0.5*iterations. See documentation for rstan for more details.}

\item{adapt_delta}{Target average proposal acceptance probability during Stan's adaptation period. The default value is 0.90. See documentation for rstan for more details.}

\item{max_treedepth}{Cap on the depth of the trees evaluated during each iteration. The default value is 15. See documentation for rstan for more details.}

\item{init}{Initial values for estimated parameters. The default is random initial values. See documentation for rstan for more details.}

\item{thin}{Thinning. The default value is 1. See documentation for rstan for more details.}

\item{cores}{The number of computer cores used for parallel computing. The default value is 2.}

\item{ma}{Mean of the prior distribution for alpha, which follows a lognormal distribution. The default value is 0.}

\item{va}{Standard deviation of the prior distribution for alpha. The default value is 0.5.}

\item{mdne}{Mean of the prior distribution for negative deltas, which follows a normal distribution. The default value is -1.}

\item{mdnu}{Mean of the prior distribution for neutral deltas, which follows a normal distribution. The default value is 0.}

\item{mdpo}{Mean of the prior distribution for positive deltas, which follows a normal distribution. The default value is 1.}

\item{vd}{Standard deviation of the prior distribution for deltas. The default value is 1.}

\item{mt}{Means of the prior distributions for taus, which follows a normal distribution. The default values are seq(-3, 0, 3/(options-1)). The last one has to be 0. For items with only 2 options, we recommend to use (-2, 0) as means of priors.}

\item{vt}{Standard deviation of the prior distribution for taus. The default value is 2.}
}
\value{
Result object that stores information including the (1) stanfit object, (2) estimated item parameters, (3) estimated person parameters, (4) correlations among traits, (5) regression coefficients linking person covariates to each trait, (6) response data (excluding respondents who endorse a single option across all items), and (7) the input row vector mapping each item to each trait. Note that when covariates are included, output (4) represents residual correlations among the traits after controlling for the covariates.
}
\description{
This function implements full Bayesian estimation of Multidimensional Generalized Graded Unfolding Model (MGGUM) using rstan
}
\examples{
Data <- c(1,4,2,3)
Data <- matrix(Data,nrow = 2)
deli <- c(1,-1,2,1)
deli <- matrix(deli,nrow = 2)
ind <- c(1,2)
ind <- t(ind)
cova <- c(0.70, -1.25)
mod <- bmggum(GGUM.Data=Data,delindex=deli,trait=2,ind=ind,option=4,covariate=cova,iter=5,chains=1)
}
