// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_gp_marginal_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 92> locations_array__ =
  {" (found before start of program)",
  " (in 'gp_marginal', line 34, column 2 to column 17)",
  " (in 'gp_marginal', line 35, column 2 to column 20)",
  " (in 'gp_marginal', line 36, column 2 to column 25)",
  " (in 'gp_marginal', line 37, column 2 to column 23)",
  " (in 'gp_marginal', line 38, column 2 to column 42)",
  " (in 'gp_marginal', line 41, column 7 to column 9)",
  " (in 'gp_marginal', line 41, column 0 to column 19)",
  " (in 'gp_marginal', line 42, column 7 to column 9)",
  " (in 'gp_marginal', line 42, column 11 to column 13)",
  " (in 'gp_marginal', line 42, column 0 to column 19)",
  " (in 'gp_marginal', line 43, column 7 to column 9)",
  " (in 'gp_marginal', line 43, column 11 to column 13)",
  " (in 'gp_marginal', line 43, column 0 to column 20)",
  " (in 'gp_marginal', line 44, column 6 to column 8)",
  " (in 'gp_marginal', line 44, column 0 to column 18)",
  " (in 'gp_marginal', line 45, column 8 to column 10)",
  " (in 'gp_marginal', line 45, column 12 to column 14)",
  " (in 'gp_marginal', line 45, column 0 to column 18)",
  " (in 'gp_marginal', line 46, column 8 to column 10)",
  " (in 'gp_marginal', line 46, column 12 to column 14)",
  " (in 'gp_marginal', line 46, column 0 to column 22)",
  " (in 'gp_marginal', line 47, column 0 to column 7)",
  " (in 'gp_marginal', line 48, column 1 to column 56)",
  " (in 'gp_marginal', line 49, column 1 to column 50)",
  " (in 'gp_marginal', line 50, column 20 to column 74)",
  " (in 'gp_marginal', line 50, column 1 to column 74)",
  " (in 'gp_marginal', line 51, column 20 to column 72)",
  " (in 'gp_marginal', line 51, column 1 to column 72)",
  " (in 'gp_marginal', line 52, column 20 to column 73)",
  " (in 'gp_marginal', line 52, column 1 to column 73)",
  " (in 'gp_marginal', line 53, column 16 to column 84)",
  " (in 'gp_marginal', line 53, column 1 to column 84)",
  " (in 'gp_marginal', line 56, column 5 to column 53)",
  " (in 'gp_marginal', line 58, column 5 to column 29)",
  " (in 'gp_marginal', line 55, column 18 to line 59, column 4)",
  " (in 'gp_marginal', line 55, column 0 to line 59, column 4)",
  " (in 'gp_marginal', line 54, column 18 to line 60, column 2)",
  " (in 'gp_marginal', line 54, column 0 to line 60, column 2)",
  " (in 'gp_marginal', line 61, column 15 to column 47)",
  " (in 'gp_marginal', line 61, column 0 to column 47)",
  " (in 'gp_marginal', line 62, column 0 to column 30)",
  " (in 'gp_marginal', line 63, column 0 to column 19)",
  " (in 'gp_marginal', line 65, column 4 to column 34)",
  " (in 'gp_marginal', line 64, column 0 to line 65, column 34)",
  " (in 'gp_marginal', line 69, column 4 to column 37)",
  " (in 'gp_marginal', line 68, column 1 to line 69, column 37)",
  " (in 'gp_marginal', line 67, column 16 to line 70, column 1)",
  " (in 'gp_marginal', line 67, column 0 to line 70, column 1)",
  " (in 'gp_marginal', line 73, column 5 to column 37)",
  " (in 'gp_marginal', line 74, column 5 to column 41)",
  " (in 'gp_marginal', line 72, column 18 to line 75, column 4)",
  " (in 'gp_marginal', line 72, column 2 to line 75, column 4)",
  " (in 'gp_marginal', line 71, column 16 to line 76, column 1)",
  " (in 'gp_marginal', line 71, column 0 to line 76, column 1)",
  " (in 'gp_marginal', line 78, column 1 to column 44)",
  " (in 'gp_marginal', line 77, column 18 to line 79, column 2)",
  " (in 'gp_marginal', line 77, column 1 to line 79, column 2)",
  " (in 'gp_marginal', line 81, column 1 to column 23)",
  " (in 'gp_marginal', line 82, column 1 to column 32)",
  " (in 'gp_marginal', line 83, column 1 to column 28)",
  " (in 'gp_marginal', line 84, column 1 to column 28)",
  " (in 'gp_marginal', line 80, column 15 to line 85, column 1)",
  " (in 'gp_marginal', line 80, column 0 to line 85, column 1)",
  " (in 'gp_marginal', line 12, column 0 to column 16)",
  " (in 'gp_marginal', line 13, column 0 to column 16)",
  " (in 'gp_marginal', line 14, column 0 to column 16)",
  " (in 'gp_marginal', line 15, column 0 to column 15)",
  " (in 'gp_marginal', line 16, column 0 to column 20)",
  " (in 'gp_marginal', line 17, column 0 to column 19)",
  " (in 'gp_marginal', line 18, column 0 to column 31)",
  " (in 'gp_marginal', line 19, column 6 to column 12)",
  " (in 'gp_marginal', line 19, column 0 to column 32)",
  " (in 'gp_marginal', line 20, column 6 to column 11)",
  " (in 'gp_marginal', line 20, column 0 to column 30)",
  " (in 'gp_marginal', line 21, column 6 to column 11)",
  " (in 'gp_marginal', line 21, column 0 to column 23)",
  " (in 'gp_marginal', line 22, column 7 to column 9)",
  " (in 'gp_marginal', line 22, column 11 to column 12)",
  " (in 'gp_marginal', line 22, column 0 to column 16)",
  " (in 'gp_marginal', line 23, column 0 to column 36)",
  " (in 'gp_marginal', line 24, column 0 to column 34)",
  " (in 'gp_marginal', line 25, column 0 to column 21)",
  " (in 'gp_marginal', line 26, column 0 to column 40)",
  " (in 'gp_marginal', line 27, column 7 to column 9)",
  " (in 'gp_marginal', line 27, column 11 to column 13)",
  " (in 'gp_marginal', line 27, column 0 to column 20)",
  " (in 'gp_marginal', line 28, column 0 to column 22)",
  " (in 'gp_marginal', line 31, column 9 to column 11)",
  " (in 'gp_marginal', line 31, column 2 to column 38)",
  " (in 'gp_marginal', line 34, column 9 to column 10)",
  " (in 'gp_marginal', line 38, column 8 to column 28)"};
#include <stan_meta_header.hpp>
class model_gp_marginal final : public model_base_crtp<model_gp_marginal> {
private:
  int sn;
  int tn;
  int nT;
  int p;
  int ntmiss;
  int ntobs;
  int missing;
  std::vector<int> data_miss_idx;
  std::vector<int> data_obs_idx;
  std::vector<double> yobs;
  Eigen::Matrix<double,-1,-1> X_data__;
  std::vector<double> sigma2_prior;
  std::vector<double> tau2_prior;
  int phidist;
  std::vector<double> prior_phi_param;
  Eigen::Matrix<double,-1,-1> dist_data__;
  int verbose;
  Eigen::Matrix<double,-1,1> mu_0_data__;
  int z_miss_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> dist{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mu_0{nullptr, 0};
public:
  ~model_gp_marginal() {}
  model_gp_marginal(stan::io::var_context& context__, unsigned int
                    random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_gp_marginal_namespace::model_gp_marginal";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 64;
      context__.validate_dims("data initialization", "sn", "int",
        std::vector<size_t>{});
      sn = std::numeric_limits<int>::min();
      current_statement__ = 64;
      sn = context__.vals_i("sn")[(1 - 1)];
      current_statement__ = 64;
      stan::math::check_greater_or_equal(function__, "sn", sn, 0);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "tn", "int",
        std::vector<size_t>{});
      tn = std::numeric_limits<int>::min();
      current_statement__ = 65;
      tn = context__.vals_i("tn")[(1 - 1)];
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "tn", tn, 0);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "nT", "int",
        std::vector<size_t>{});
      nT = std::numeric_limits<int>::min();
      current_statement__ = 66;
      nT = context__.vals_i("nT")[(1 - 1)];
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "nT", nT, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 67;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "ntmiss", "int",
        std::vector<size_t>{});
      ntmiss = std::numeric_limits<int>::min();
      current_statement__ = 68;
      ntmiss = context__.vals_i("ntmiss")[(1 - 1)];
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "ntmiss", ntmiss, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "ntobs", "int",
        std::vector<size_t>{});
      ntobs = std::numeric_limits<int>::min();
      current_statement__ = 69;
      ntobs = context__.vals_i("ntobs")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "ntobs", ntobs, 0);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "missing", "int",
        std::vector<size_t>{});
      missing = std::numeric_limits<int>::min();
      current_statement__ = 70;
      missing = context__.vals_i("missing")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "missing", missing, 0);
      current_statement__ = 70;
      stan::math::check_less_or_equal(function__, "missing", missing, 1);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("data_miss_idx", "ntmiss",
        ntmiss);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "data_miss_idx", "int",
        std::vector<size_t>{static_cast<size_t>(ntmiss)});
      data_miss_idx = std::vector<int>(ntmiss,
                        std::numeric_limits<int>::min());
      current_statement__ = 72;
      data_miss_idx = context__.vals_i("data_miss_idx");
      current_statement__ = 73;
      stan::math::validate_non_negative_index("data_obs_idx", "ntobs", ntobs);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "data_obs_idx", "int",
        std::vector<size_t>{static_cast<size_t>(ntobs)});
      data_obs_idx = std::vector<int>(ntobs, std::numeric_limits<int>::min());
      current_statement__ = 74;
      data_obs_idx = context__.vals_i("data_obs_idx");
      current_statement__ = 75;
      stan::math::validate_non_negative_index("yobs", "ntobs", ntobs);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "yobs", "double",
        std::vector<size_t>{static_cast<size_t>(ntobs)});
      yobs = std::vector<double>(ntobs,
               std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 76;
      yobs = context__.vals_r("yobs");
      current_statement__ = 77;
      stan::math::validate_non_negative_index("X", "nT", nT);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("X", "p", p);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(nT), static_cast<size_t>(p)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(nT, p,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), nT,
        p);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 79;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 79;
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            current_statement__ = 79;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 79;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 80;
      context__.validate_dims("data initialization", "sigma2_prior",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      sigma2_prior = std::vector<double>(2,
                       std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 80;
      sigma2_prior = context__.vals_r("sigma2_prior");
      current_statement__ = 80;
      stan::math::check_greater_or_equal(function__, "sigma2_prior",
        sigma2_prior, 0);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "tau2_prior", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      tau2_prior = std::vector<double>(2,
                     std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 81;
      tau2_prior = context__.vals_r("tau2_prior");
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__, "tau2_prior",
        tau2_prior, 0);
      current_statement__ = 82;
      context__.validate_dims("data initialization", "phidist", "int",
        std::vector<size_t>{});
      phidist = std::numeric_limits<int>::min();
      current_statement__ = 82;
      phidist = context__.vals_i("phidist")[(1 - 1)];
      current_statement__ = 82;
      stan::math::check_greater_or_equal(function__, "phidist", phidist, 0);
      current_statement__ = 83;
      context__.validate_dims("data initialization", "prior_phi_param",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      prior_phi_param = std::vector<double>(2,
                          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 83;
      prior_phi_param = context__.vals_r("prior_phi_param");
      current_statement__ = 83;
      stan::math::check_greater_or_equal(function__, "prior_phi_param",
        prior_phi_param, 0);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("dist", "sn", sn);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("dist", "sn", sn);
      current_statement__ = 86;
      context__.validate_dims("data initialization", "dist", "double",
        std::vector<size_t>{static_cast<size_t>(sn), static_cast<size_t>(sn)});
      dist_data__ = Eigen::Matrix<double,-1,-1>::Constant(sn, sn,
                      std::numeric_limits<double>::quiet_NaN());
      new (&dist) Eigen::Map<Eigen::Matrix<double,-1,-1>>(dist_data__.data(),
        sn, sn);
      {
        std::vector<local_scalar_t__> dist_flat__;
        current_statement__ = 86;
        dist_flat__ = context__.vals_r("dist");
        current_statement__ = 86;
        pos__ = 1;
        current_statement__ = 86;
        for (int sym1__ = 1; sym1__ <= sn; ++sym1__) {
          current_statement__ = 86;
          for (int sym2__ = 1; sym2__ <= sn; ++sym2__) {
            current_statement__ = 86;
            stan::model::assign(dist, dist_flat__[(pos__ - 1)],
              "assigning variable dist", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 86;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 87;
      context__.validate_dims("data initialization", "verbose", "int",
        std::vector<size_t>{});
      verbose = std::numeric_limits<int>::min();
      current_statement__ = 87;
      verbose = context__.vals_i("verbose")[(1 - 1)];
      current_statement__ = 87;
      stan::math::check_greater_or_equal(function__, "verbose", verbose, 0);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("mu_0", "sn", sn);
      current_statement__ = 89;
      mu_0_data__ = Eigen::Matrix<double,-1,1>::Constant(sn,
                      std::numeric_limits<double>::quiet_NaN());
      new (&mu_0) Eigen::Map<Eigen::Matrix<double,-1,1>>(mu_0_data__.data(),
        sn);
      current_statement__ = 89;
      stan::model::assign(mu_0, stan::math::rep_vector(0, sn),
        "assigning variable mu_0");
      current_statement__ = 90;
      stan::math::validate_non_negative_index("beta", "p", p);
      current_statement__ = 91;
      z_miss_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 91;
      z_miss_1dim__ = (missing ? ntmiss : 0);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("z_miss",
        "missing ? ntmiss : 0", z_miss_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = p + 1 + 1 + 1 + z_miss_1dim__;
  }
  inline std::string model_name() const final {
    return "model_gp_marginal";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_gp_marginal_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_sq = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      std::vector<local_scalar_t__> z_miss =
        std::vector<local_scalar_t__>(z_miss_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      z_miss = in__.template read<
                 std::vector<local_scalar_t__>>(z_miss_1dim__);
      {
        current_statement__ = 6;
        stan::math::validate_non_negative_index("xbmodel", "nT", nT);
        Eigen::Matrix<local_scalar_t__,-1,1> xbmodel =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nT, DUMMY_VAR__);
        current_statement__ = 8;
        stan::math::validate_non_negative_index("mus", "tn", tn);
        current_statement__ = 9;
        stan::math::validate_non_negative_index("mus", "sn", sn);
        Eigen::Matrix<local_scalar_t__,-1,-1> mus =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(tn, sn,
            DUMMY_VAR__);
        current_statement__ = 11;
        stan::math::validate_non_negative_index("dats", "tn", tn);
        current_statement__ = 12;
        stan::math::validate_non_negative_index("dats", "sn", sn);
        Eigen::Matrix<local_scalar_t__,-1,-1> dats =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(tn, sn,
            DUMMY_VAR__);
        current_statement__ = 14;
        stan::math::validate_non_negative_index("z1", "nT", nT);
        std::vector<local_scalar_t__> z1 =
          std::vector<local_scalar_t__>(nT, DUMMY_VAR__);
        current_statement__ = 16;
        stan::math::validate_non_negative_index("L", "sn", sn);
        current_statement__ = 17;
        stan::math::validate_non_negative_index("L", "sn", sn);
        Eigen::Matrix<local_scalar_t__,-1,-1> L =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(sn, sn,
            DUMMY_VAR__);
        current_statement__ = 19;
        stan::math::validate_non_negative_index("Sigma", "sn", sn);
        current_statement__ = 20;
        stan::math::validate_non_negative_index("Sigma", "sn", sn);
        Eigen::Matrix<local_scalar_t__,-1,-1> Sigma =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(sn, sn,
            DUMMY_VAR__);
        local_scalar_t__ u = DUMMY_VAR__;
        current_statement__ = 23;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(sigma_sq,
                         stan::model::rvalue(sigma2_prior, "sigma2_prior",
                           stan::model::index_uni(1)),
                         stan::model::rvalue(sigma2_prior, "sigma2_prior",
                           stan::model::index_uni(2))));
        current_statement__ = 24;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(tau_sq,
                         stan::model::rvalue(tau2_prior, "tau2_prior",
                           stan::model::index_uni(1)),
                         stan::model::rvalue(tau2_prior, "tau2_prior",
                           stan::model::index_uni(2))));
        current_statement__ = 26;
        if (stan::math::logical_eq(phidist, 0)) {
          current_statement__ = 25;
          lp_accum__.add(stan::math::uniform_lpdf<propto__>(phi,
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(1)),
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(2))));
        }
        current_statement__ = 28;
        if (stan::math::logical_eq(phidist, 1)) {
          current_statement__ = 27;
          lp_accum__.add(stan::math::gamma_lpdf<propto__>(phi,
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(1)),
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(2))));
        }
        current_statement__ = 30;
        if (stan::math::logical_eq(phidist, 2)) {
          current_statement__ = 29;
          lp_accum__.add(stan::math::cauchy_lpdf<propto__>(phi,
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(1)),
                           stan::model::rvalue(prior_phi_param,
                             "prior_phi_param", stan::model::index_uni(2))));
        }
        current_statement__ = 32;
        if (stan::math::logical_gt(phidist, 2)) {
          current_statement__ = 31;
          std::stringstream errmsg_stream__;
          stan::math::stan_print(&errmsg_stream__,
            "Wrong prior distribution for phi; found phidist=");
          stan::math::stan_print(&errmsg_stream__, phidist);
          throw std::domain_error(errmsg_stream__.str());
        }
        current_statement__ = 38;
        for (int i = 1; i <= (sn - 1); ++i) {
          current_statement__ = 36;
          for (int j = (i + 1); j <= sn; ++j) {
            current_statement__ = 33;
            stan::model::assign(Sigma, (sigma_sq *
              stan::math::exp(((-1 * phi) *
                stan::model::rvalue(dist, "dist", stan::model::index_uni(i),
                  stan::model::index_uni(j))))), "assigning variable Sigma",
              stan::model::index_uni(i), stan::model::index_uni(j));
            current_statement__ = 34;
            stan::model::assign(Sigma,
              stan::model::rvalue(Sigma, "Sigma", stan::model::index_uni(i),
                stan::model::index_uni(j)), "assigning variable Sigma",
              stan::model::index_uni(j), stan::model::index_uni(i));
          }
        }
        current_statement__ = 40;
        for (int i = 1; i <= sn; ++i) {
          current_statement__ = 39;
          stan::model::assign(Sigma, (sigma_sq + tau_sq),
            "assigning variable Sigma", stan::model::index_uni(i),
            stan::model::index_uni(i));
        }
        current_statement__ = 41;
        stan::model::assign(L, stan::math::cholesky_decompose(Sigma),
          "assigning variable L");
        current_statement__ = 42;
        stan::model::assign(xbmodel, stan::math::multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 44;
        for (int i = 1; i <= ntobs; ++i) {
          current_statement__ = 43;
          stan::model::assign(z1,
            stan::model::rvalue(yobs, "yobs", stan::model::index_uni(i)),
            "assigning variable z1",
            stan::model::index_uni(
              stan::model::rvalue(data_obs_idx, "data_obs_idx",
                stan::model::index_uni(i))));
        }
        current_statement__ = 48;
        if (stan::math::logical_gt(missing, 0)) {
          current_statement__ = 46;
          for (int k = 1; k <= ntmiss; ++k) {
            current_statement__ = 45;
            stan::model::assign(z1,
              stan::model::rvalue(z_miss, "z_miss", stan::model::index_uni(k)),
              "assigning variable z1",
              stan::model::index_uni(
                stan::model::rvalue(data_miss_idx, "data_miss_idx",
                  stan::model::index_uni(k))));
          }
        }
        current_statement__ = 54;
        for (int i = 1; i <= tn; ++i) {
          current_statement__ = 52;
          for (int j = 1; j <= sn; ++j) {
            current_statement__ = 49;
            stan::model::assign(dats,
              stan::model::rvalue(z1, "z1",
                stan::model::index_uni((i + ((j - 1) * tn)))),
              "assigning variable dats", stan::model::index_uni(i),
              stan::model::index_uni(j));
            current_statement__ = 50;
            stan::model::assign(mus,
              stan::model::rvalue(xbmodel, "xbmodel",
                stan::model::index_uni((i + ((j - 1) * tn)))),
              "assigning variable mus", stan::model::index_uni(i),
              stan::model::index_uni(j));
          }
        }
        current_statement__ = 57;
        for (int t = 1; t <= tn; ++t) {
          current_statement__ = 55;
          lp_accum__.add(stan::math::multi_normal_cholesky_lpdf<propto__>(
                           stan::model::rvalue(dats, "dats",
                             stan::model::index_uni(t)),
                           stan::model::rvalue(mus, "mus",
                             stan::model::index_uni(t)), L));
        }
        current_statement__ = 63;
        if (stan::math::logical_gt(verbose, 0)) {
          current_statement__ = 58;
          if (pstream__) {
            stan::math::stan_print(pstream__, "beta= ");
            stan::math::stan_print(pstream__, beta);
            *(pstream__) << std::endl;
          }
          current_statement__ = 59;
          if (pstream__) {
            stan::math::stan_print(pstream__, "sigma sq = ");
            stan::math::stan_print(pstream__, sigma_sq);
            *(pstream__) << std::endl;
          }
          current_statement__ = 60;
          if (pstream__) {
            stan::math::stan_print(pstream__, "tau sq = ");
            stan::math::stan_print(pstream__, tau_sq);
            *(pstream__) << std::endl;
          }
          current_statement__ = 61;
          if (pstream__) {
            stan::math::stan_print(pstream__, "range = ");
            stan::math::stan_print(pstream__, (3.0 / phi));
            *(pstream__) << std::endl;
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_gp_marginal_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      double phi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      double sigma_sq = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      sigma_sq = in__.template read_constrain_lb<local_scalar_t__,
                   jacobian__>(0, lp__);
      double tau_sq = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      tau_sq = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      std::vector<double> z_miss =
        std::vector<double>(z_miss_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      z_miss = in__.template read<
                 std::vector<local_scalar_t__>>(z_miss_1dim__);
      out__.write(beta);
      out__.write(phi);
      out__.write(sigma_sq);
      out__.write(tau_sq);
      out__.write(z_miss);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, phi);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_sq = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_sq);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, tau_sq);
      std::vector<local_scalar_t__> z_miss =
        std::vector<local_scalar_t__>(z_miss_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(z_miss,
        in__.read<std::vector<local_scalar_t__>>(z_miss_1dim__),
        "assigning variable z_miss");
      out__.write(z_miss);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "phi", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma_sq",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "tau_sq", "double",
        std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "z_miss", "double",
        std::vector<size_t>{static_cast<size_t>(z_miss_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = context__.vals_r("phi")[(1 - 1)];
      out__.write_free_lb(0, phi);
      local_scalar_t__ sigma_sq = DUMMY_VAR__;
      current_statement__ = 3;
      sigma_sq = context__.vals_r("sigma_sq")[(1 - 1)];
      out__.write_free_lb(0, sigma_sq);
      local_scalar_t__ tau_sq = DUMMY_VAR__;
      current_statement__ = 4;
      tau_sq = context__.vals_r("tau_sq")[(1 - 1)];
      out__.write_free_lb(0, tau_sq);
      std::vector<local_scalar_t__> z_miss =
        std::vector<local_scalar_t__>(z_miss_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      z_miss = context__.vals_r("z_miss");
      out__.write(z_miss);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"beta", "phi", "sigma_sq", "tau_sq",
                "z_miss"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(p)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(z_miss_1dim__)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    param_names__.emplace_back(std::string() + "tau_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "z_miss" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    param_names__.emplace_back(std::string() + "tau_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "z_miss" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(z_miss_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(z_miss_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((p + 1) + 1) + 1) + z_miss_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((p + 1) + 1) + 1) + z_miss_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_gp_marginal_namespace::model_gp_marginal;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_gp_marginal_namespace::profiles__;
}
#endif
#endif
