% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_bnns.R
\name{predict.bnns}
\alias{predict.bnns}
\title{Predict Method for \code{"bnns"} Objects}
\usage{
\method{predict}{bnns}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"bnns"}, typically the result of a call to \code{\link{bnns.default}}.}

\item{newdata}{A matrix or data frame of new input data for which predictions are required. If \code{NULL}, predictions are made on the training data used to fit the model.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A matrix/array of predicted values(regression)/probabilities(classification) where first dimension corresponds to the rows of \code{newdata} or the training data if \code{newdata} is \code{NULL}. Second dimension corresponds to the number of posterior samples. In case of \code{out_act_fn = 3}, the third dimension corresponds to the class.
}
\description{
Generates predictions from a fitted Bayesian Neural Network (BNN) model.
}
\details{
This function uses the posterior distribution from the Stan model in the \code{bnns} object to compute predictions for the provided input data.
}
\examples{
\donttest{
# Example usage:
data <- data.frame(x1 = runif(10), x2 = runif(10), y = rnorm(10))
model <- bnns(y ~ -1 + x1 + x2,
  data = data, L = 1, nodes = 2, act_fn = 2,
  iter = 1e1, warmup = 5, chains = 1
)
new_data <- data.frame(x1 = runif(5), x2 = runif(5))
predictions <- predict(model, newdata = new_data)
print(predictions)
}
}
\seealso{
\code{\link{bnns}}, \code{\link{print.bnns}}
}
