% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gera.pa.R
\name{gera.pa}
\alias{gera.pa}
\title{Generates a PA model}
\usage{
gera.pa(bn.structure, data.to.work, pa.name, pa.imgname, bn.algorithm,
  bn.score.test, outcome.var)
}
\arguments{
\item{bn.structure}{is a BN structure learned from data.}

\item{data.to.work}{is a data frame containing the variables of the BN.}

\item{pa.name}{is a variable to store the name of file to save PA parameters.}

\item{pa.imgname}{is a variable to store the name of file to save PA graph.}

\item{bn.algorithm}{is a list of algorithms to learn the BN structure.}

\item{bn.score.test}{is a list of tests to be used during BN structure learning.}

\item{outcome.var}{is the outcome variable.}
}
\description{
This function receives a BN structure learned, the data set and some parameters and build a PA input model string. Then run the PA model using Structural Equation Model functions and export a PA graph and a PA model summary information.
}
\examples{
\dontrun{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("To your working directory")
# Load packages
library(bnpa)
# Load data sets from package
data(dataQualiN)
# Show first lines
head(dataQualiN)
# Learn BN structure
bn.structure <- bnlearn::hc(dataQualiN)
bnlearn::graphviz.plot(bn.structure)
# Set variables
pa.name<-"docPAHC"
pa.imgname<-"imgPAHC"
bn.algorithm<-"hc"
bn.score.test<-"aic-g"
outcome.var<-"D"
# Generates the PA model from bn structure
gera.pa(bn.structure, dataQualiN, pa.name, pa.imgname, bn.algorithm, bn.score.test, outcome.var)
}
}
\references{
Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2),1-36.
}
\author{
Elias Carvalho
}
