% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fares_metadata.R
\name{get_fares_metadata}
\alias{get_fares_metadata}
\title{Return fares metadata from the 'BODS' API}
\usage{
get_fares_metadata(
  api_key = Sys.getenv("BODS_KEY"),
  limit = 25,
  noc = NULL,
  status = NULL,
  bounding_box = NULL
)
}
\arguments{
\item{api_key}{API key for the 'BODS' dataset passed as a string.
Can be obtained from \href{https://data.bus-data.dft.gov.uk/api/}{the 'BODS' API login}}

\item{limit}{integer. Maximum number of records to return for a query. Defaults to 25}

\item{noc}{string or vector of strings. Limit results to fares data sets for specified National Operator Codes.
A full lookup of NOC to bus operator names can be seen using noc_lookup().
Defaults to NULL.}

\item{status}{string. Limit results to fares data sets for specified status,
accepted values are "published" or "inactive". Defaults to NULL.}

\item{bounding_box}{vector of four numerics. Limit results to fares data sets
that contain information for the area within the rectangular boundingBox
you set using co-ordinates [minLatitude, maxLatitude, minLongitude, maxLongitude].
Defaults to NULL.}
}
\value{
Returns a data frame of fares metadata including links to data from the 'BODS' API.
}
\description{
Return fares metadata from the 'BODS' API
}
\examples{

\dontrun{
#Before running these examples, ensure you have an API key saved
#Return the first 25 results of fares metadata with no filters
get_fares_metadata()

#Return fares metadata for National Express
get_fares_metadata(noc = "NATX")

#Return only published fares metadata for Go Ahead
get_fares_metadata(noc = "BHBC", status = "published")

#Return fares metadata for the specified bounding box
get_fares_metadata(bounding_box = c(51.401, 51.509, 0.01, 0.201))
}
}
