% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-export-functions.R
\name{boilerplate_export}
\alias{boilerplate_export}
\title{Export boilerplate Database}
\usage{
boilerplate_export(
  db,
  output_file = NULL,
  select_elements = NULL,
  data_path = NULL,
  format = "rds",
  confirm = TRUE,
  create_dirs = FALSE,
  quiet = FALSE,
  pretty = TRUE,
  save_by_category = TRUE,
  project = "default"
)
}
\arguments{
\item{db}{List. The database to export (unified or single category).}

\item{output_file}{Character. Optional output filename. If NULL, uses default naming.}

\item{select_elements}{Character vector. Optional paths to export (supports wildcards).}

\item{data_path}{Character. Base path for data directory.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{format}{Character. Format to save: "rds" (default), "json", or "both".}

\item{confirm}{Logical. If TRUE (default), asks for confirmation before overwriting.}

\item{create_dirs}{Logical. If TRUE, creates directories if they don't exist.}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{pretty}{Logical. If TRUE (default), pretty-print JSON for readability.}

\item{save_by_category}{Logical. If TRUE (default), saves unified databases by category.}

\item{project}{Character. Project name for organizing databases. Default is "default".
Projects are stored in separate subdirectories to allow multiple independent
boilerplate collections.}
}
\value{
Invisible TRUE if successful.
}
\description{
This function exports a boilerplate database or selected elements to disk.
It supports exporting entire databases, specific categories, or selected
elements using dot notation paths. Can export in RDS, JSON, or both formats.
}
\examples{
# Create a temporary directory and initialise databases
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_export_example", "data")

# Initialise and import databases
boilerplate_init(
  categories = c("methods", "measures"),
  data_path = data_path,
  create_dirs = TRUE,
  confirm = FALSE,
  quiet = TRUE
)

unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Export entire database
export_path <- file.path(temp_dir, "export")
boilerplate_export(
  db = unified_db,
  data_path = export_path,
  create_dirs = TRUE,
  confirm = FALSE,
  quiet = TRUE
)

# Export selected elements
boilerplate_export(
  db = unified_db,
  select_elements = "methods.*",
  output_file = "methods_only.rds",
  data_path = export_path,
  confirm = FALSE,
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_export_example"), recursive = TRUE)

}
