% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_bondPricingUsingSpotRates.R
\name{pricingWithSpots}
\alias{pricingWithSpots}
\title{Calculate Present Value or the Price of the Bond using Spot Rates.}
\usage{
pricingWithSpots(coupons, spots, times, mv, n)
}
\arguments{
\item{coupons}{A vector.}

\item{spots}{A vector.}

\item{times}{A vector.}

\item{mv}{A number.}

\item{n}{A number.}
}
\value{
Input values to five arguments  \code{coupons} , \code{spots},\code{times}, \code{mv}, and \code{n}.
}
\description{
Calculate Present Value or the Price of the Bond using Spot Rates.
}
\details{
When a fixed-rate bond is priced using the market discount rate, the same discount rate is used for each cash flow. A more fundamental approach to calculate the price of a bond is to use a sequence of market discount rates that correspond to the cash flow dates. These market discount rates are called spot rates. Spot rates are yields-to-maturity on zero-coupon bonds maturing at the date of each cash flow. Sometimes, these are called zero rates (Adams & Smith, 2019).
Based on the information provided, the method  \code{pricingWithSpots()} is developed to compute the Price of Bond using the Spot Rates. So,  \code{pricingWithSpots()} gives the Price of Bond using Spots for values passed to its five arguments. Here, \code{coupons} represent the dollar values of all the coupon payments, \code{spots} is a vector of spot rates, \code{times} is a vector of number of years ranging from 1 to any specified number of years till maturity, \code{mv} is Maturity Value, and \code{n} is number of years till maturity. The output is rounded off to two decimal places. The given examples show various ways in which the arguments can be passed to \code{pricingWithSpots()}.
Suppose that the one-year spot rate is 2 percent, the two-year spot rate is 3 percent, and the three-year spot rate is 4 percent. Then, the price of a three-year bond that makes a 5 percent annual coupon payment is 102.960.
}
\examples{
pricingWithSpots(coupons=c(5,5,5), spots=c(0.02,0.03,0.04), times=c(1,2,3),mv=100,n=3)
pricingWithSpots(coupons=c(5,5,5), spots=c(0.02,0.03,0.04), times=c(1:3),mv=100,n=3)
pricingWithSpots(coupons=c(rep(5,3)), spots=c(0.02,0.03,0.04), times=c(1:3),mv=100,n=3)
pricingWithSpots(c(rep(5,3)), c(0.02,0.03,0.04), c(1:3),100,3)
pricingWithSpots(coupons=c(rep(10,2)), spots=c(0.01,0.02), times=c(1:2),mv=100,n=2)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
