% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{ca_col_cos2}
\alias{ca_col_cos2}
\alias{ca_col_sup_cos2}
\title{Compute col squared cosines}
\usage{
ca_col_cos2(col_coords, X)

ca_col_sup_cos2(col_coords, X_sup, X)
}
\arguments{
\item{col_coords}{col coordinates}

\item{X}{active dataset}

\item{X_sup}{supplementary dataset}
}
\value{
A dataframe of col squared cosines.
}
\description{
Return col squared cosines for each correspondence component
}
\examples{
library(booklet)

X_scaled <- mtcars[, c(2, 8:11)] |>
  ca_standardize()

X_scaled |>
  ca_weighted_eigen() |>
  ca_col_coords() |>
  ca_col_cos2(X_scaled) |>
  head()
}
