% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARSBoost.R
\name{MARSBoost}
\alias{MARSBoost}
\alias{MARSBoost_object}
\title{LS-Boosting with adapted Multivariate Adaptive Frontier Splines (MARS)}
\usage{
MARSBoost(data, x, y, num.iterations, num.terms, learning.rate)

MARSBoost_object(
  data,
  x,
  y,
  num.iterations,
  learning.rate,
  num.terms,
  MARS.models,
  f0,
  prediction,
  prediction.smooth
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the variables
in the model.}

\item{x}{Column input indexes in \code{data}.}

\item{y}{Column output indexes in \code{data}.}

\item{num.iterations}{Maximum number of iterations the algorithm will perform}

\item{num.terms}{Maximum number of reflected pairs created by the forward
algorithm of MARS.}

\item{learning.rate}{Learning rate that control overfitting of the algorithm.
Value must be in (0,1]}

\item{MARS.models}{List of the adapted forward MARS models created in each
iterations}

\item{f0}{Initial predictions of the model (they correspond to maximum value
of each output variable)}

\item{prediction}{Final predictions of the original data without applying
the smoothing procedure}

\item{prediction.smooth}{Final predictions of the original data after
applying the smoothing procedure}
}
\value{
A \code{MARSBoost} object.

A \code{MARSBoost} object.
}
\description{
This function estimates a production frontier satisfying some
classical production theory axioms, such as monotonicity and concavity,
which is based upon the adaptation of the machine learning technique known
 as LS-boosting using adapted Multivariate Adaptive Regression Splines (MARS)
 as base learners.

This function saves information about the LS-Boosted
Multivariate Adaptive Frontier Splines model.
}
