
# branchingprocess

<!-- badges: start -->

[![ForeSITE
Group](https://github.com/EpiForeSITE/software/raw/e82ed88f75e0fe5c0a1a3b38c2b94509f122019c/docs/assets/foresite-software-badge.svg)](https://github.com/EpiForeSITE)
[![R-CMD-check](https://github.com/EpiForeSITE/branchingprocess/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/EpiForeSITE/branchingprocess/actions/workflows/R-CMD-check.yaml)
[![pkgdown](https://github.com/EpiForeSITE/branchingprocess/actions/workflows/pkgdown.yaml/badge.svg)](https://github.com/EpiForeSITE/branchingprocess/actions/workflows/pkgdown.yaml)
<!-- badges: end -->

## Calculate Outbreak Probabilities for a Branching Process Model

The goal of `branchingprocess` is to quantify outbreak risk posed by
individual importers of a transmissible pathogen. Input parameters of
negative binomial offspring distributions for the number of
transmissions from each infected individual and initial number of
infected. Calculate probabilities of final outbreak size and generations
of transmission. A full description and derivation of the mathematical
results implemented in these functions can be found in the following
manuscripts:

- Toth D, Gundlapalli A, Khader K, Pettey W, Rubin M, Adler F, Samore M
  (2015). Estimates of outbreak risk from new introductions of Ebola
  with immediate and delayed transmission control. Emerg Infect Dis,
  21(8), 1402-1408. <https://doi.org/10.3201/eid2108.150170>.

- Toth D, Tanner W, Khader K, Gundlapalli A (2016). Estimates of the
  risk of large or long-lasting outbreaks of Middle East respiratory
  syndrome after importations outside the Arabian Peninsula. Epidemics,
  16, 27-32. <https://doi.org/10.1016/j.epidem.2016.04.002>

Work to create this software tool was made possible by cooperative
agreement CDC-RFA-FT-23-0069 from the CDC’s Center for Forecasting and
Outbreak Analytics.

## Installation

You can install the development version of `branchingprocess` from
GitHub with:

``` r
devtools::install_github("EpiForeSITE/branchingprocess")
```

You can install branchingprocess from CRAN with:

``` r
install.packages("branchingprocess")
```
