% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mentions.R
\name{bwr_mentions_toptweeters}
\alias{bwr_mentions_toptweeters}
\title{Get a dataframe of top Tweeter for a specified Brandwatch query or query group}
\usage{
bwr_mentions_toptweeters(project_id = NULL, query_id = NULL,
  querygrp_id = NULL, date_range = c(Sys.Date() - 31, Sys.Date() - 1),
  filters = NULL, token = Sys.getenv("BW_TOKEN"))
}
\arguments{
\item{project_id}{The project id in which the specified query is contained. Obtain a list of project IDs using bwr_get_projects().}

\item{query_id}{The query ID you'd like to see tweeter data for. Note that you can only specify a query or a query group, not both.}

\item{querygrp_id}{The query group ID you'd like to see total mentions for.
Note that you can only specify a query or a query group, not both.}

\item{date_range}{A character vector containing 2 date values in YYYY-mm-dd format.
The first value is the beginning of your desired date range and the second value is the end of the date range.}

\item{filters}{(Optional) A list of key-value pairs to filter the mentions query by.
Use the bwr_filters_get() function to find out all available filters.}

\item{token}{The authentication token, acquired using bwr_auth()}
}
\value{
Returns a data frame (including some list-columns) of the JSON results,
showing information about the top tweeters related to your query.
}
\description{
Get a dataframe of top Tweeter for a specified Brandwatch query or query group
}
\examples{
\dontrun{my_project <- bwr_projects_get()$id[1]
my_query <- bwr_query_get(project_id = my_project)$id[1]
my_mentions <- bwr_mentions_toptweeters(project_id = my_project,
                                        query_id = my_query,
                                        date_range = c('2018-01-01', '2018-02-01'))}
}
