% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{binarize.y}
\alias{binarize.y}
\title{Recode a Variable with Two Unique Values into an 0/1 Vector}
\usage{
binarize.y(y, verbose = FALSE)
}
\arguments{
\item{y}{a vector, must contain two unique values.}

\item{verbose}{a logical value, TRUE or FALSE, indicating whehter details are to be printed on the screen.}
}
\value{
a list with three elements: \code{y}, a vector of the same length as \code{y}, whose entries are coded to 0 and 1, \code{coding.scheme}, a character string describing the map from the original coding to 0/1 coding, and \code{ycode}, a character vector containing the original level names of \code{y}.
}
\description{
Recode a Variable with Two Unique Values into an 0/1 Vector
}
\examples{
y <- factor(c('good', 'bad', 'good', 'good', 'bad'))
(yb <- binarize.y(y))
y <- c(TRUE, FALSE, FALSE, FALSE, TRUE)
(yb <- binarize.y(y))
y <- c(1, 2, 2, 1, 2)
(yb <- binarize.y(y))
}
