% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{bsnsing.formula}
\alias{bsnsing.formula}
\title{Learn a Classification Tree using Boolean Sensing}
\usage{
\method{bsnsing}{formula}(formula, data, subset, na.action = stats::na.pass, ...)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{bsnsing.formula} is called.}

\item{subset}{an optional vector specifying a subset (in terms of index numbers, not actual data) of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. If \code{na.pass} is used, \code{bsnsing} will still apply an internal NA treatment logic, as follows: missing values in numeric variables will be replaced by the median of the non-missing values of the variable; missing values in factor variables will be treated as a spearate level named 'NA'.}

\item{...}{additional arguments to be passed to the low level fitting functions, e.g., elements in the \code{\link{bscontrol}} object.}
}
\value{
an object of \code{\link{bsnsing}} for a two-class problem or an object of \code{\link{mbsnsing}} for a multi-class problem.
}
\description{
The program builds a binary classification tree for each unique value in the response variable. Each tree classifies a target value against all the other values (internally coded as 'all.other') in the response variable. If the response variable is a numeric type, the number of unique values must not exceed 30. There is no programmatic restriction on the number of unique levels for a factor response.
}
\examples{
# Multi-class classification
bs <- bsnsing(Species ~ ., data = iris)
summary(bs)
summary(bs[[1]])  # display the tree for the first class
summary(bs[[2]])  # display the tree for the second class
summary(bs[[3]])  # display the tree for the third class

# Two-class classification
bs <- bsnsing(origin ~ mpg + displacement + horsepower + weight, data = auto, verbose = TRUE)
summary(bs)
}
