% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shiny_iconlink}
\alias{shiny_iconlink}
\title{Create link containing Shiny icon}
\usage{
shiny_iconlink(name = "info-circle", id = NULL, ...)
}
\arguments{
\item{name}{character, name of the icon, passed to \verb{shiny::[icon][shiny::icon]}}

\item{id}{character, option ID for the link}

\item{...}{other arguments passed to \verb{shiny::[icon][shiny::icon]}}
}
\value{
\verb{htmltools::[tag][htmltools::tag]}, \verb{<a/>}
}
\description{
You can use this helper function to wrap link element
around a \verb{shiny::[icon][shiny::icon]}.
It may be useful to attach a modal window to
(or embed a popover into) into such a link.
}
\examples{
shiny_iconlink()

shiny_iconlink() \%>\%
  bs_embed_popover(title = "Help!", content = "I need somebody")

}
\seealso{
\code{\link[=shinyInput_label_embed]{shinyInput_label_embed()}},
\verb{shiny::[icon][shiny::icon]}, \code{\link[=bs_attach_modal]{bs_attach_modal()}},
\code{\link[=bs_embed_popover]{bs_embed_popover()}}, \code{\link[=bs_embed_tooltip]{bs_embed_tooltip()}}
}
