% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{thinsamples}
\alias{thinsamples}
\title{Thin a bstrlstate object}
\usage{
thinsamples(state, count)
}
\arguments{
\item{state}{Object of class bstrlstate, output by bipartiteRL, SMCMCupdate,
PPRBupdate, or multifileRL}

\item{count}{The number of desired samples after filtering}
}
\value{
An object of class bstrlstate, containing count samples.
}
\description{
Thin a bstrlstate object by keeping only one sample every n, until the
desired count remains.
}
\details{
This is useful to do before an SMCMC update. SMCMC produces
independent samples, so fewer are required to get the same quality estimates.
}
\examples{
data(geco_small_result)
filtered <- thinsamples(geco_small_result, 50)
stopifnot(ncol(filtered$Z) == 50)

}
