% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-files.R
\name{btw_tool_files_write_text_file}
\alias{btw_tool_files_write_text_file}
\title{Tool: Write a text file}
\usage{
btw_tool_files_write_text_file(path, content, `_intent` = "")
}
\arguments{
\item{path}{Path to the file to write. The \code{path} must be in the current
working directory.}

\item{content}{The text content to write to the file. This should be the
complete content as the file will be overwritten.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a message confirming the file was written.
}
\description{
Tool: Write a text file
}
\examples{
withr::with_tempdir({
  btw_tool_files_write_text_file("example.txt", "Hello\nWorld!")
  readLines("example.txt")
})

}
\seealso{
Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
