% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-sessioninfo.R
\name{btw_tool_session_package_info}
\alias{btw_tool_session_package_info}
\title{Tool: Gather information about a package or currently loaded packages}
\usage{
btw_tool_session_package_info(
  packages = "attached",
  dependencies = "",
  `_intent` = ""
)
}
\arguments{
\item{packages}{Which packages to show, or \code{"loaded"} to show all loaded
packages, \code{"attached"} to show all attached packages, or \code{"installed"} to
show all installed packages.}

\item{dependencies}{Whether to include the dependencies when listing package
information.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a string describing the selected packages.
}
\description{
Uses \code{\link[sessioninfo:package_info]{sessioninfo::package_info()}} to provide information about the loaded,
attached, or installed packages. The primary use case is to verify that a
package is installed; check the version number of a specific packages; or
determine which packages are already in use in a session.
}
\examples{
btw_tool_session_package_info("btw")

}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}, \code{\link[=btw_tool_session_platform_info]{btw_tool_session_platform_info()}}

Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
