% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loess.R
\name{fit_loess}
\alias{fit_loess}
\title{Fit a loess curve to a bullet data frame}
\usage{
fit_loess(bullet, groove, span = 0.75)
}
\arguments{
\item{bullet}{The bullet object as returned from fortify_x3p}

\item{groove}{vector of two numeric values indicating the location of the left and right groove.}

\item{span}{The span to use for the loess regression}
}
\value{
a list of a data frame of the original bullet measurements extended by loess fit, residuals, and standard errors and two plots: a plot of the fit, and a plot of the bullet's land signature.
}
\description{
First, the surface measurements of the bullet land is trimmed to be within left and right groove as specified by vector \code{groove}.
A loess regression is fit to the remaining surface measurements and residuals are calculated.
The most extreme 0.25% of residuals are filtered from further consideration.
The result is called the signature of the bullet land.
}
