% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_estimate_transmissision_flows.r
\name{estimate_multinom_ci}
\alias{estimate_multinom_ci}
\alias{estim_multinom_ci}
\alias{est_multinom_ci}
\alias{estimate_multinom_ci.default}
\title{\code{estimate_multinom_ci} Estimates confidence intervals for transmission flows}
\usage{
estimate_multinom_ci(df_theta_hat, ...)

\method{estimate_multinom_ci}{default}(df_theta_hat, detailed_report = FALSE, ...)
}
\arguments{
\item{df_theta_hat}{A data.frame returned by the function: \code{\link[=estimate_theta_hat]{estimate_theta_hat()}}}

\item{\dots}{Further arguments.}

\item{detailed_report}{A boolean value to produce detailed output of the analysis. (Default is \code{FALSE})}
}
\value{
Returns a data.frame containing:
\itemize{
\item H1_group, Name of population group 1
\item H2_group, Name of population group 2
\item number_hosts_sampled_group_1, Number of individuals sampled from population group 1
\item number_hosts_sampled_group_2, Number of individuals sampled from population group 2
\item number_hosts_population_group_1, Estimated number of individuals in population group 1
\item number_hosts_population_group_2, Estimated number of individuals in population group 2
\item max_possible_pairs_in_sample, Number of distinct possible transmission pairs between individuals sampled from population groups 1 and 2
\item max_possible_pairs_in_population, Number of distinct possible transmission pairs between individuals in population groups 1 and 2
\item num_linked_pairs_observed, Number of observed directed transmission pairs between samples from population groups 1 and 2
\item p_hat, Probability that pathogen sequences from two individuals randomly sampled from their respective population groups are linked
\item est_linkedpairs_in_population, Estimated transmission pairs between population groups 1 and 2
\item theta_hat, Estimated transmission flows or relative probability of transmission within and between population groups 1 and 2 adjusted
for sampling heterogeneity. More precisely, the conditional probability that a pair of pathogen sequences is from a specific population
group pairing given that the pair is linked.
\item obs_trm_pairs_est_goodman, Point estimate, Goodman method Confidence intervals for observed transmission pairs
\item obs_trm_pairs_lwr_ci_goodman, Lower bound of Goodman confidence interval
\item obs_trm_pairs_upr_ci_goodman, Upper bound of Goodman confidence interval
\item est_goodman, Point estimate, Goodman method Confidence intervals for estimated transmission flows
\item lwr_ci_goodman, Lower bound of Goodman confidence interval
\item upr_ci_goodman, Upper bound of Goodman confidence interval
}

The following additional fields are returned if the detailed_report flag is set

\itemize{
\item est_goodman_cc, Point estimate, Goodman method Confidence intervals with continuity correction
\item lwr_ci_goodman_cc, Lower bound of Goodman confidence interval
\item upr_ci_goodman_cc, Upper bound of Goodman confidence interval
\item est_sisonglaz, Point estimate, Sison-Glaz method Confidence intervals
\item lwr_ci_sisonglaz, Lower bound of Sison-Glaz confidence interval
\item upr_ci_sisonglaz, Upper bound of Sison-Glaz confidence interval
\item est_qhurst_acswr, Point estimate, Queensbury-Hurst method Confidence intervals via ACSWR r package
\item lwr_ci_qhurst_acswr, Lower bound of Queensbury-Hurst confidence interval
\item upr_ci_qhurst_acswr, Upper bound of Queensbury-Hurst confidence interval
\item est_qhurst_coinmind, Point estimate, Queensbury-Hurst method Confidence intervals via CoinMinD r package
\item lwr_ci_qhurst_coinmind, Lower bound of Queensbury-Hurst confidence interval
\item upr_ci_qhurst_coinmind, Upper bound of Queensbury-Hurst confidence interval
\item lwr_ci_qhurst_adj_coinmind, Lower bound of Queensbury-Hurst confidence interval adjusted
\item upr_ci_qhurst_adj_coinmind, Upper bound of Queensbury-Hurst confidence interval adjusted
}
}
\description{
This function computes simultaneous confidence intervals at the
5\% significance level for estimated transmission flows. Available
methods for computing confidence intervals are: Goodman, Goodman
with a continuity correction, Sison-Glaz and Queensbury-Hurst.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Estimates confidence intervals for transmission flows
}}

\examples{
library(bumblebee)
library(dplyr)

# Compute confidence intervals for estimated transmission flows

# We shall use the data of HIV transmissions within and between intervention and control
# communities in the BCPP/Ya Tsie HIV prevention trial. To learn more about the data 
# ?counts_hiv_transmission_pairs and ?sampling_frequency


# Load and view data
#
# The data comprises counts of observed directed HIV transmission pairs between individuals 
# sampled from intervention and control communities (i.e. num_linked_pairs_observed); 
# and the estimated HIV transmissions within and between intervention and control 
# communities in the BCPP/Ya Tsie trial population adjusted for sampling heterogneity
# (i.e. \code{est_linkedpairs_in_population}). See ?estimate_theta_hat() for details on 
# computing \code{est_linkedpairs_in_population} and \code{theta_hat}.

results_estimate_theta_hat <- estimated_hiv_transmission_flows[, c(1:13)]
 
results_estimate_theta_hat
 
# Compute Goodman confidence intervals (Default)
results_estimate_multinom_ci <- estimate_multinom_ci(
    df_theta_hat = results_estimate_theta_hat, 
    detailed_report = FALSE)

# View results
results_estimate_multinom_ci

# Compute Goodman, Sison-Glaz and Queensbury-Hurst confidence intervals
results_estimate_multinom_ci_detailed <- estimate_multinom_ci(
    df_theta_hat = results_estimate_theta_hat, 
    detailed_report = TRUE)

# View results
results_estimate_multinom_ci_detailed

}
\references{
\enumerate{

\item Magosi LE, et al., Deep-sequence phylogenetics to quantify patterns of
HIV transmission in the context of a universal testing and treatment
trial – BCPP/ Ya Tsie trial. To submit for publication, 2021.

\item Goodman, L. A. On Simultaneous Confidence Intervals for Multinomial Proportions
Technometrics, 1965. 7, 247-254.

\item Cherry, S., A Comparison of Confidence Interval Methods for Habitat
Use-Availability Studies. The Journal of Wildlife Management, 1996.
60(3): p. 653-658.

\item Sison, C.P and Glaz, J. Simultaneous confidence intervals and sample size determination
for multinomial proportions. Journal of the American Statistical Association,
1995. 90:366-369.

\item Glaz, J., Sison, C.P. Simultaneous confidence intervals for multinomial proportions.
Journal of Statistical Planning and Inference, 1999. 82:251-262.

\item May, W.L., Johnson, W.D. Constructing two-sided simultaneous confidence intervals for
multinomial proportions for small counts in a large number of cells.
Journal of Statistical Software, 2000. 5(6).
Paper and code available at https://www.jstatsoft.org/v05/i06.

\item Carnegie, N.B., et al., Linkage of viral sequences among HIV-infected
village residents in Botswana: estimation of linkage rates in the
presence of missing data. PLoS Computational Biology, 2014. 10(1):
p. e1003430.

\item Ratmann, O., et al., Inferring HIV-1 transmission networks and sources of
epidemic spread in Africa with deep-sequence phylogenetic analysis.
Nature Communications, 2019. 10(1): p. 1411.

\item Wymant, C., et al., PHYLOSCANNER: Inferring Transmission from Within- and
Between-Host Pathogen Genetic Diversity. Molecular Biology and Evolution,
2017. 35(3): p. 719-733.
}
}
\seealso{
See \code{\link{estimate_theta_hat}} to prepare input data to estimate confidence intervals.\preformatted{     To learn more about the Goodman and Sison-Glaz confidence interval methods 
     see \code{\link[DescTools]{MultinomCI}}. For Queensbury-Hurst confidence
     intervals see \code{\link[ACSWR]{QH_CI}} and \code{\link[CoinMinD]{QH}}
}
}
