% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cristin_units.R
\name{CristinUnits}
\alias{CristinUnits}
\title{create a tibble with information about selected Cristin units}
\usage{
CristinUnits(unit.key, subunits = TRUE, recursive = FALSE, lang = "en")
}
\arguments{
\item{unit.key}{Unit to search for}

\item{subunits}{Add subunits, Default: TRUE}

\item{recursive}{Search for (nested) subunits, Default: FALSE}

\item{lang}{PARAM_DESCRIPTION, Default: `en`}
}
\value{
A tibble containing information about selected units
}
\description{
Create a tibble with information about (nested) units in Cristin
 (e.g., A University -> Faculties -> Departments -> Groups). The tibble can
 than be used to extract data for each unit from Cristin. Used by
 `CristinMonthly`
}
\details{
Used with `CristinMontlhy` to create month-to-month bibliography of
selected units
}
\examples{
\donttest{
# Find units for Inland University
  CristinUnits("209.0.0.0") |>
    dplyr::select(id, path2) |>
    print(width = 80)
}
}
\seealso{
\code{\link[httr]{RETRY}}
 \code{\link[dplyr]{transmute}}, \code{\link[dplyr]{bind_rows}}
 \code{\link[purrr]{pmap}}
}
