% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_economic_regions.R
\name{get_economic_regions}
\alias{get_economic_regions}
\title{Canadian Map at Economic Region (ER) Level}
\usage{
get_economic_regions(map = census_divisions)
}
\arguments{
\item{map}{which map to add, by default it takes the complete Census
Divisions (CD) map}
}
\value{
a tibble with economic regions, provinces and geometry
(multipolygon) fields.
}
\description{
This function aggregates the Census Divisions (CD) map
to provide the Economic Region (ER) map. The idea is to avoid providing
a dataset with map that can be obtained as an aggregation of another.
}
\examples{
get_economic_regions(
 census_divisions[census_divisions$prname == "Ontario",]
)
}
