% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_klink_circles}
\alias{make_klink_circles}
\title{Generate Multiple Interlocked Circles in High-Dimensional Space}
\usage{
make_klink_circles(n = c(200, 100), p = 4, k = 2, offset = 0.5)
}
\arguments{
\item{n}{An integer vector of length \eqn{k} giving the number of points
in each circle. Default is \code{c(200, 100)}.}

\item{p}{Integer, the dimensionality of the embedding space. Must be
at least 3. Default is \code{4}.}

\item{k}{Integer, the number of circles to generate. Default is \code{2}.}

\item{offset}{Numeric, the amount of positional shift applied to each
circle along the second coordinate axis to prevent complete overlap.
Default is \code{0.5}.}
}
\value{
A data frame (or tibble, depending on \code{gen_multicluster()})
  containing the generated points and cluster assignments.
}
\description{
This function generates \eqn{k} interlocked circular clusters in a
\eqn{p}-dimensional space. The circles are constructed using
\code{gen_multicluster()}, with each circle positioned in a different
coordinate plane and slightly offset so that they interlock with a
central circle (hub-like structure).
}
\examples{
# Generate two interlocked circles in 4-D
twolink_circles <- make_klink_circles()
}
