% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ard_conditions.R
\name{.cli_groups_and_variable}
\alias{.cli_groups_and_variable}
\title{Locate Condition Messages in an ARD}
\usage{
.cli_groups_and_variable(x)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}
}
\value{
a string
}
\description{
Prints a string of all \code{group##}/\code{group##_level} column values and
\code{variable} column values where condition messages occur, formatted
using glue syntax.
}
\examples{
ard <- ard_summary(
  ADSL,
  by = ARM,
  variables = AGE,
  statistic = ~ list(
    mean = \(x) mean(x),
    mean_warning = \(x) {
      warning("warn1")
      warning("warn2")
      mean(x)
    },
    err_fn = \(x) stop("'tis an error")
  )
)

cards:::.cli_groups_and_variable(ard)
}
\keyword{internal}
