% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowmap.R
\name{flowmap}
\alias{flowmap}
\title{Mapping of an origin-destination flow matrix}
\usage{
flowmap(
  tab,
  fij,
  origin.f,
  destination.f,
  bkg = NULL,
  crs,
  nodes = NULL,
  code,
  nodes.X,
  nodes.Y,
  filter,
  plota,
  threshold,
  taille,
  a.head,
  a.length,
  a.angle,
  a.col,
  add = NULL,
  ...
)
}
\arguments{
\item{tab}{the input flow dataset in .csv format. See Details}

\item{fij}{the flow value between origin and destination places}

\item{origin.f}{the place of origin code}

\item{destination.f}{the place of destination code}

\item{bkg}{a spatial feature layer, as a map background, in .shp or .json or other format}

\item{crs}{the coordinate reference system (CRS)}

\item{nodes}{the input points file in .csv format}

\item{code}{the spatial features code}

\item{nodes.X}{the X coordinate of the point or places}

\item{nodes.Y}{the Y coordinate of the point or places}

\item{filter}{is to filter or not the flow values. See details}

\item{plota}{is to add spatial features as map background to the flows's plot}

\item{threshold}{the value of the threshold criterion to filter flows. Default is 1.}

\item{taille}{the value of the width of the flow feature}

\item{a.head}{for arrow's head is the arrow head parameter code.
It allows to choose the kind of arrow. See Details}

\item{a.length}{for arrow's length is the length of the edges of the arrow head (in inches)}

\item{a.angle}{for arrow's angle is the angle from the shaft of the arrow to the edge of the arrow head}

\item{a.col}{for arrow's color}

\item{add}{is to allow to overlay flow features on external spatial features background}

\item{...}{Adds the set of variables of the arrow function}
}
\value{
a matrix or a list with the correct flow dataframe ID code

The resulting flowmap
}
\description{
Mapping of an origin-destination flow matrix
}
\details{
The input .csv flow dataset must be first converted to a dataframe
for optimal performance (troubles remains with tibble format)\cr \cr

- filter is "FALSE" means that all the flow value will be plot as segments [(n*(n-1)],
i.e. all the OD matrice's cells out of the main diagonal will be plot.\cr
- filter is "TRUE" means only non-zero values will be plot,
i.e. existing links with or without threshold.\cr
The default threshold is set to 1.\cr

Flow features are plot as segments betwwen (x0,y0) and (x1,y1)\cr
- a.head is for applying an arrow or not to a segment:\cr
-- code="0" : the link has no head - no arrow\cr
-- code="1" : an arrow is draw at (x0[i], y0[i])\cr
-- code="2" : an arrow is draw at (x1[j], y1[j])\cr
-- code="3" : an arrow is draw at both nodes.\cr
}
\examples{
rm(list=ls())
library(cartograflow)
library(sf)
data(flowdata)
# example with the background
map <- st_read(system.file("shape/MGP_TER.shp", package = "cartograflow"))
par(bg = "NA")
plot(st_geometry(map), col = "blue")
flowmap(
  tab = flows, fij = "Fij", origin.f = "i", destination.f = "j",
  bkg = map,add=TRUE, code = "EPT_NUM", nodes.X = "X", nodes.Y = "Y",
  filter = FALSE
)
}
