% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascadeSelect.R
\name{cascadeSelectInput}
\alias{cascadeSelectInput}
\title{Cascade select input}
\usage{
cascadeSelectInput(
  inputId,
  choices,
  selected = NULL,
  placeholder = "Select",
  optionLabel,
  optionGroupLabel,
  optionGroupChildren,
  theme = "bootstrap4-dark-purple"
)
}
\arguments{
\item{inputId}{the id that will be used to get the selected value in Shiny}

\item{choices}{a hierarchical list (see the example); each item is given by
a list with \emph{must} contain an \code{icon} field created with the
\code{\link{Icon}} function}

\item{selected}{the selected value; \code{NULL} for none}

\item{placeholder}{placeholder appearing when no selected value}

\item{optionLabel}{the label of the options to be selected}

\item{optionGroupLabel}{the label of the groups of options; there can be
several groups and they must have the same label}

\item{optionGroupChildren}{a list of the names of the groups of options}

\item{theme}{the CSS theme; see \code{data(themes)} for the list of
available themes}
}
\value{
A \code{shiny.tag.list} object to be included in a Shiny UI.
}
\description{
Create a cascade select input for Shiny.
}
\examples{
library(shiny)
library(cascadeSelect)

## | the hierarchical list of choices
folders <- list(
  list( # first folder
    name = "bootstrap", icon = Icon("bi bi-bootstrap", color = "purple"),
    subfolders = list(
      list( # subfolder of the first folder
        name = "css", icon = Icon("bi bi-folder-fill", color = "orange"),
        files = list(
          list(
            fname = "bootstrap-theme.css", size = "25 KB",
            icon = Icon("bi bi-filetype-css", color = "steelblue")
          ),
          list(
            fname = "bootstrap.css", size = "142 KB",
            icon = Icon("bi bi-filetype-css", color = "steelblue")
          )
        )
      ),
      list( # subfolder of the first folder
        name = "js", icon = Icon("bi bi-folder-fill", color = "orange"),
        files = list(
          list(
            fname = "bootstrap.js", size = "74 KB",
            icon = Icon("bi bi-filetype-js", color = "yellow")
          ),
          list(
            fname = "npm.js", size = "484 B",
            icon = Icon("bi bi-filetype-js", color = "yellow")
          )
        )
      )
    )
  ),
  list( # second folder
    name = "datatables", icon = Icon("bi bi-table", color = "purple"),
    subfolders = list(
      list( # subfolder of the second folder
        name = "css", icon = Icon("bi bi-folder-fill", color = "orange"),
        files = list(
          list(
            fname = "dataTables.bootstrap.css", size = "7.5 KB",
            icon = Icon("bi bi-filetype-css", color = "steelblue")
          ),
          list(
            fname = "dataTables.extra.css", size = "1.2 KB",
            icon = Icon("bi bi-filetype-css", color = "steelblue")
          )
        )
      ),
      list( # subfolder of the second folder
        name = "js", icon = Icon("bi bi-folder-fill", color = "orange"),
        files = list(
          list(
            fname = "dataTables.bootstrap.js", size = "4.2 KB",
            icon = Icon("bi bi-filetype-js", color = "yellow")
          ),
          list(
            fname = "jquerydataTable.min.js", size = "77.1 KB",
            icon = Icon("bi bi-filetype-js", color = "yellow")
          )
        )
      )
    )
  )
)

## | the Shiny app
ui <- fluidPage(
  titlePanel("Cascade Select"),
  fluidRow(
    column(
      6,
      cascadeSelectInput(
        "cascade",
        choices = folders,
        placeholder = "Select a file",
        optionLabel = "fname",
        optionGroupLabel = "name",
        optionGroupChildren = list("subfolders", "files"),
        theme = "bootstrap4-dark-purple"
      ),
      br(),br(),
      uiOutput("textOutput")
    )
  )
)

server <- function(input, output, session) {
  output[["textOutput"]] <- renderUI({
    choice <- req(input[["cascade"]])
    tagList(
      tags$h4("You selected the file: ", sQuote(choice[["fname"]]), "."),
      tags$h4("Its size is: " , choice[["size"]], ".")
    )
  })
}

if(interactive()) {
  shinyApp(ui, server)
}


# other example, with different group depths ###
library(shiny)
library(cascadeSelect)

folderHaskell <- list(
  list( # first folder
    name = "findPatternInFiles",
    icon = Icon("bi bi-folder-fill", color = "orange"),
    sub = list(
      list( # subfolder of the first folder
        name = "src", icon = Icon("bi bi-folder-fill", color = "orange"),
        subsub = list(
          list( # file
            fname = "GetAhaHTML.hs", icon = Icon("oi oi-haskell")
          ),
          list( # file
            fname = "GetGrepResults.hs", icon = Icon("oi oi-haskell")
          )
        )
      ),
      list( # subfolder of the first folder
        name = "src-exe", icon = Icon("bi bi-folder-fill", color = "orange"),
        subsub = list(
          list( # file
            fname = "Main.hs", icon = Icon("oi oi-haskell")
          )
        )
      ),
      list( # file in the first folder
        fname = "findPatternInFiles.cabal", icon = Icon("oi oi-cabal")
      ),
      list( # file in the first folder
        fname = "LICENSE", icon = Icon("oi oi-license")
      ),
      list( # file in the first folder
        fname = "README.md", icon = Icon("oi oi-markdown")
      ),
      list( # file in the first folder
        fname = "Setup.hs", icon = Icon("oi oi-haskell")
      ),
      list( # file in the first folder
        fname = "stack.yaml", icon = Icon("oi oi-yaml")
      ),
      list( # file in the first folder
        fname = ".gitignore", icon = Icon("bi bi-git")
      )
    )
  )
)

ui <- fluidPage(
  titlePanel("My Haskell project"),
  fluidRow(
    column(
      6,
      cascadeSelectInput(
        "cascade",
        choices = folderHaskell,
        placeholder = "Select a file",
        optionLabel = "fname",
        optionGroupLabel = "name",
        optionGroupChildren = list("sub", "subsub"),
        theme = "luna-amber"
      ),
      br(),br(),
      textOutput("textOutput")
    )
  )
)

server <- function(input, output, session) {
  output[["textOutput"]] <- renderText({
    choice <- input[["cascade"]]
    sprintf(
      "You selected the file: \%s.", dQuote(choice[["fname"]])
    )
  })
}

if(interactive()) {
  shinyApp(ui, server)
}
}
