% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTriangle.R
\docType{methods}
\name{setUpperTriangle}
\alias{setUpperTriangle}
\alias{setUpperTriangle,Triangle,data.frame-method}
\alias{setUpperTriangle,ANY-method}
\title{Set up the upper triangle based on claim data.}
\usage{
setUpperTriangle(object, data, ...)

\S4method{setUpperTriangle}{Triangle,data.frame}(object, data,
  evaluationDate = as.Date("2016-12-31"), lob = "Total",
  ctype = "Total")
}
\arguments{
\item{object}{Triangle Object}

\item{data}{Claim Data}

\item{...}{Additional function arguments.}

\item{evaluationDate}{Evaluation Date;}

\item{lob}{Line of Business;}

\item{ctype}{Claim Type.}
}
\description{
\code{setUpperTriangle} sets up the upper triangle based on a data file.
}
\examples{
library(cascsim)
data(claimdata)
xTri <- new("Triangle", triID = "TRI1", type = "reportedCount", startDate=as.Date("2012-01-01"),
frequency="yearly", sim=1, percentile=50)
xTri<-setUpperTriangle(xTri,claimdata)
xTri@upper

xTri <- new("Triangle", triID = "TRI1", type = "closedCount", startDate=as.Date("2012-01-01"),
frequency="quarterly", sim=1, percentile=50)
xTri<-setUpperTriangle(xTri,claimdata)
xTri@upper

xTri <- new("Triangle", triID = "TRI1", type = "incurredLoss", startDate=as.Date("2012-01-01"),
frequency="yearly", sim=1, percentile=50)
xTri<-setUpperTriangle(xTri,claimdata,lob="Auto",ctype="H")
xTri@upper

xTri <- new("Triangle", triID = "TRI1", type = "paidLoss", startDate=as.Date("2012-01-01"),
frequency="yearly", sim=1, percentile=50)
xTri<-setUpperTriangle(xTri,claimdata,lob="Auto",ctype="H")
xTri@upper

}
