% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{riskdiff.matrix}
\alias{riskdiff.matrix}
\title{Risk difference}
\usage{
\method{riskdiff}{matrix}(df, conf.level = 0.95, dnn = NULL,
  rev = c("neither", "rows", "columns", "both"), ...)
}
\arguments{
\item{df}{a 2 x 2 frequency matrix.}

\item{conf.level}{confidence level for confidence interval, default is 0.95.}

\item{dnn}{optional character vector of dimension names.}

\item{rev}{reverse order of cells. Options are "row", "columns", "both", and "neither" (default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "rdiff" containing the following components:

\item{rd}{risk difference}
\item{conf.level}{specified confidence level}
\item{ci}{calculated confidence interval}
\item{p1}{proportion one}
\item{p2}{proportion two}
\item{tab}{2x2 table using for calculating risk difference}
}
\description{
Calculate risk difference and 95 percent confidence interval using Wald method.
}
\examples{
matrix(c(12, 45, 69, 15), nrow = 2, ncol = 2) \%>\%
   riskdiff(dnn = c("New Drug", "Adverse Outcome"))
}
