% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\title{Compute confusion matrix for comparing two adjacency matrices}
\usage{
confusion(est_amat, true_amat, type = "adj")
}
\arguments{
\item{est_amat}{The estimated adjacency matrix}

\item{true_amat}{The true adjacency matrix}

\item{type}{String indicating whether the confusion matrix should be computed for adjacencies
(\code{"adj"}, the default) or for (conditional) orientations (\code{dir}).}
}
\value{
A list with entries \code{$tp} (number of true positives),  \code{$tn} (number of true negatives),
\code{$fp} (number of false positives), and  \code{$tp} (number of false negatives).
}
\description{
Two adjacency matrices are compared either in terms of adjacencies
(\code{type = "adj"}) or orientations (\code{type = "dir"}).
}
\details{
In the former case, the confusion matrix is a cross-tabulation
of adjacencies.

In the latter case, the orientation confusion matrix is conditional on agreement on
adjacency. This means that only adjacencies that are shared in both input matrices are
considered, and agreement wrt. orientation is then computed only among these edges
that occur in both matrices. A true positive is a correctly placed arrowhead (1),
a false positive marks placement of arrowhead (1) where there should have been a tail (0),
a false negative marks placement of tail (0) where there should have been an arrowhead (1),
and a true negative marks correct placement of a tail (0).
}
