% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_study.R
\name{get_segments_by_study}
\alias{get_segments_by_study}
\title{Get Copy Number Segmentation Data By Study}
\usage{
get_segments_by_study(study_id = NULL, add_hugo = TRUE, base_url = NULL)
}
\arguments{
\item{study_id}{A study ID to query mutations. If NULL, guesses study ID based
on molecular_profile_id.}

\item{add_hugo}{Logical indicating whether \code{HugoGeneSymbol} should be added to your resulting data frame, if not already present in raw API results.
Argument is \code{TRUE} by default. If \code{FALSE}, results will be returned as is (i.e. any existing Hugo Symbol columns in raw results will not be removed).}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of CNA segments
}
\description{
Get Copy Number Segmentation Data By Study
}
\examples{
\dontrun{
get_segments_by_study(study_id = "prad_msk_2019")
get_segments_by_study(molecular_profile_id = "prad_msk_2019_cna")
}
}
