% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_reduced_rank_regression.R
\name{cca_graph_rrr_cv}
\alias{cca_graph_rrr_cv}
\title{Graph-regularized Reduced-Rank Regression for Canonical Correlation Analysis with cross validation}
\usage{
cca_graph_rrr_cv(
  X,
  Y,
  Gamma,
  r = 2,
  lambdas = 10^seq(-3, 1.5, length.out = 10),
  kfolds = 5,
  parallelize = FALSE,
  standardize = TRUE,
  LW_Sy = FALSE,
  rho = 10,
  niter = 10000,
  thresh = 1e-04,
  thresh_0 = 1e-06,
  verbose = FALSE,
  Gamma_dagger = NULL,
  nb_cores = NULL
)
}
\arguments{
\item{X}{Matrix of predictors (n x p)}

\item{Y}{Matrix of responses (n x q)}

\item{Gamma}{Graph constraint matrix (g x p)}

\item{r}{Target rank}

\item{lambdas}{Grid of regularization parameters to test for sparsity}

\item{kfolds}{Number of folds for cross-validation}

\item{parallelize}{Whether to parallelize cross-validation}

\item{standardize}{Whether to center and scale X and Y (default FALSE = center only)}

\item{LW_Sy}{Whether to apply Ledoit-Wolf shrinkage to Sy}

\item{rho}{ADMM penalty parameter}

\item{niter}{Maximum number of ADMM iterations}

\item{thresh}{Convergence threshold for ADMM}

\item{thresh_0}{Threshold for small values in the coefficient matrix (default 1e-6)}

\item{verbose}{Whether to print diagnostic output}

\item{Gamma_dagger}{Optional pseudoinverse of Gamma (computed if NULL)}

\item{nb_cores}{Number of cores to use for parallelization (default is all available cores minus 1)}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{lambda}{Optimal regularisation parameter lambda chosen by CV}
\item{rmse}{Mean squared error of prediction (as computed in the CV)}
\item{cor}{Canonical covariances}
}
}
\description{
Solves a sparse canonical correlation problem using a graph-constrained reduced-rank regression formulation.
The problem is solved via an ADMM approach.
}
