context("test checkData function")

test_that("whether the function gives correct argument dataframe",{
  set.seed(1)
  data("ICAapp")
  dapprp = ICAapp$dapprp
  expect_error(checkData('dapprp','trt1','trt2','immorp',ICAapp$respid), "Data argument can only take a data.frame object.", fixed=TRUE)
  expect_error(checkData(dapprp,'trt1','trt2','immorp',ICAapp), "Y, T1, T2, and M must all be the names of the variables (as character/string) if a data frame is provided.", fixed=TRUE)
  Y = c('a','b','c','d')
  T1 = c(1,0,0,0)
  T2 = c(1,0,0,0)
  M = c(1,0,0,0)
  testdata1 = data.frame(Y,T1,T2,M)
  expect_error(checkData('Y','T1','T2','M',testdata1), "Y, T1, T2, and M must all be numeric.", fixed=TRUE)
  Y = c(24,NA,39,68,9,6,1)
  T1 = c(1,0,0,1,NA,0,1)
  T2 = c(1,0,1,0,1,0,0)
  M = c(7,3,9,6,7,2,3)
  testdata2 = data.frame(Y,T1,T2,M)
  expect_warning(checkData('Y','T1','T2','M',testdata2), "2 observations removed due to NA values.", fixed=TRUE)
  expect_warning(checkData('Y','T1','T2','M',testdata2), "1 observations with T1 = T2 = 1 removed.", fixed=TRUE)
  Y = c(24,12,39,68,9,6,1)
  T1 = c(0,0,0,2,0,0,1)
  T2 = c(1,0,1,0,1,0,0)
  M = c(7,3,9,6,7,2,3)
  testdata3 = data.frame(Y,T1,T2,M)
  expect_error(checkData('Y','T1','T2','M',testdata3), "T1 and T2 must be binary variables.", fixed=TRUE)
  Y = c(24,12,39,68,9,6,1)
  T1 = c(0,1,0,0,0,1,1)
  T2 = c(1,0,1,1,1,0,0)
  M = c(7,3,9,6,7,2,3)
  testdata4 = data.frame(Y,T1,T2,M)
  expect_error(checkData('Y','T1','T2','M',testdata4), "Data must include units where (T1,T2) equals (1,0), (0,1), and (0,0).", fixed=TRUE)
})
