% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtmean.R
\name{qtmean}
\alias{qtmean}
\title{Inverse cumulative distribution function for t distribution}
\usage{
qtmean(p, mean, s2, n)
}
\arguments{
\item{p}{value of cdf (named in accordance with R standards)}

\item{mean}{the assumed normal mean}

\item{s2}{the observed sample variance (pass this as an extra argument to cdfinv())}

\item{n}{the sample size (pass this as an extra argument to cdfinv())}
}
\value{
The value of sample mean corresponding to the input quantile p of the t distribution for n-1 degrees of freedom
}
\description{
Computes the value of sample mean corresponding to the input quantile p of the t distribution for n-1 degrees of freedom
}
\details{
Do not call qtmean() directly.
Pass DISTR="tmean" to cdfinv() when computing intervals for the
normal mean when the variance is unknown.
The parameter name to be passed to cdfinv() is mean.
The additional arguments s2 (sample variance) and
n (sample size) are to be passed to cdfinv().
}
\author{
Peter E. Freeman, \email{pfreeman@cmu.edu}
}
