% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_plot.R
\name{rates_lme_summary}
\alias{rates_lme_summary}
\title{Estimate mean and confidence intervals for ATP measures using a mixed-effects model}
\usage{
rates_lme_summary(measure, assay, rates, conf_int, ci_method)
}
\arguments{
\item{measure}{Whether to plot \code{"OCR"} or \code{"ECAR"}}

\item{assay}{What assay to plot (e.g. "MITO" or "GLYCO")}

\item{rates}{a data.table of Seahorse OCR and ECAR rates (from \code{get_energetics})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}

\item{ci_method}{The method used to compute confidence intervals for the
mixed-effects model: \code{"Wald"}, \code{"profile"}, or \code{"boot"} passed to
\code{lme4::confint.merMod()}.}
}
\value{
a list of groups from the data
}
\description{
Estimates mean and standard deviation of ATP production from glycolysis and
OXPHOS at points defined in \code{partition_data} and with values calculated
using the \code{get_energetics} function
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
rates_lme_summary(
  measure = "OCR",
  assay = "MITO",
  rates = seahorse_rates,
  conf_int = 0.95,
  ci_method = "Wald"
)
}
\keyword{internal}
