% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_cebl_pbp}
\alias{load_cebl_pbp}
\title{\strong{Load CEBL Play-by-Play Data}}
\usage{
load_cebl_pbp(seasons = NULL)
}
\arguments{
\item{seasons}{A vector of seasons (years) to filter the data.}
}
\value{
A data frame containing the CEBL play-by-play data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   game_id \tab dbl \cr
   season \tab dbl \cr
   game_time \tab chr \cr
   home_score \tab dbl \cr
   away_score \tab dbl \cr
   home_lead \tab dbl \cr
   team_id \tab dbl \cr
   period \tab dbl \cr
   period_type \tab chr \cr
   player_id \tab dbl \cr
   scoreboard_name \tab chr \cr
   success \tab dbl \cr
   action_type \tab chr \cr
   action_number \tab dbl \cr
   previous_action \tab dbl \cr
   sub_type \tab chr \cr
   scoring \tab dbl \cr
   shirt_number \tab dbl \cr
   player_name \tab chr \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   x \tab dbl \cr
   y \tab dbl \cr
   qualifier_0 \tab chr \cr
   qualifier_1 \tab chr \cr
   qualifier_2 \tab chr \cr
   qualifier_3 \tab chr \cr
   international_first_name \tab chr \cr
   international_last_name \tab chr \cr
   international_first_name_initial \tab chr \cr
   international_last_name_initial \tab chr \cr
}
}
\description{
A function to load the Canadian Elite Basketball League (CEBL) play-by-play data.
}
\examples{
load_cebl_pbp(2020)
}
