% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_staged_tree.R
\docType{class}
\name{Stratified.staged.tree-class}
\alias{Stratified.staged.tree-class}
\title{Stratified.staged.tree}
\description{
A stratified staged tree is a staged tree whose supporting event tree is stratified
and all vertices which are in the same stage are also at the same distance of edges
from the root.
}
\section{Slots}{

\describe{
\item{\code{event.tree}}{Stratified.event.tree. An stratified event tree is an event tree whose set of events that unfold from all situations,
which are at the same distance of edges from the initial situation, are identical.}

\item{\code{situation}}{list.}

\item{\code{contingency.table}}{list of matrices that represent the contigency tables associated with each variable in the event tree.}

\item{\code{stage.structure}}{list in which each component is a list associated with a variable in the staged tree that has the following data structure:
\itemize{
\item $score - numeric. This is the logarithmic form of the marginal likelihood associated with a particular variable.
\item $cluster - list whose components are vectors. Each vector represents a stage associated with a particular variable.
}}

\item{\code{stage.probability}}{list in which each component is a list associated with a variable in the staged tree.
Each component of this sublist is a vector that represents the probability distribution associated with
a particular stage of the target variable.}

\item{\code{prior.distribution}}{list of matrices. Each matrix is a collection of vectors that correspond t
a prior distribution for each situation associated with a particular variable.}

\item{\code{posterior.distribution}}{list of matrices. Each matrix is a collection of vectors that correspond t
a prior distribution for each situation associated with a particular variable.}

\item{\code{model.score}}{numeric. This is the logarithmic form of the marginal likelihood.}
}}

