% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzzz.R
\name{condS}
\alias{condS}
\title{Compute the conditional survival function for Interval Censored Survival Data}
\usage{
condS(L, R, M, Delta, t, m)
}
\arguments{
\item{L}{The numericvector of left limit of observed time. For left censored observations \code{L == 0}.}

\item{R}{The numericvector of right limit of observed time. For right censored observation \code{R == inf}.}

\item{M}{An array contains marker levels for the samples.}

\item{Delta}{An array of indicator for the censored type, use 1, 2, 3 for
event happened before the left bound time, within the defined time range, and
after.}

\item{t}{A scalar indicates the predict time.}

\item{m}{A scalar for the cutoff of the marker variable.}
}
\description{
A method to compute the survival function for the
interval censored survival data based on a spline function based constrained
maximum likelihood estimator. The maximization process of likelihood is
carried out by generalized gradient projection method.
}
\references{
Wu, Yuan; Zhang, Ying. Partially monotone tensor spline estimation
of the joint distribution function with bivariate current status data.
Ann. Statist. 40, 2012, 1609-1636 <doi:10.1214/12-AOS1016>
}
\keyword{internal}
