% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce-hg.R
\name{ce_hg}
\alias{ce_hg}
\title{Convert a CE heiarchical grouping file to a data frame}
\usage{
ce_hg(year, survey, hg_zip_path = NULL, hg_file_path = NULL)
}
\arguments{
\item{year}{A year between 1996 and the last year of available CE PUMD.}

\item{survey}{The type of HG file; one of "interview", "diary", or
"integrated". Accepted as a character or symbol.}

\item{hg_zip_path}{The path to a zip file containing HG files downloaded
from the CE website. The structure of the zip file must be exactly as it is
when downloaded to be useful to this function.}

\item{hg_file_path}{The path to a single HG file that has already been
extracted. If this argument is given 'hg_zip_path' is ignored.}
}
\value{
A data frame containing the following columns:
\itemize{
\item level - hierarchical level of the expenditure category
\item title - the title of the expenditure category
\item ucc - the Universal Classification Code (UCC) for the expenditure category
\item survey - the survey instrument from which the data for a given UCC are
sourced. This is most helpful when data for a type of expenditure
are collected in both the Interview and the Diary.
\item factor - the factor by which to multiply the expenditure in the calculation
of estimated means / medians
}
}
\description{
A CE heiarchical grouping ('HG') file shows the levels of
aggregation for expenditure categories used to produce official CE
expenditure estimates. This function reads in a CE HG file for the given
year and HG type as data frame.
}
\details{
Interview and Diary HG files are available starting in 1997 and integrated
files start in 1996. For consistency, this function and other \code{cepumd}
functions only work with data starting in 1997.

The output will contain only expenditure UCCs and not UCCs related
to household characteristics, income, assets, or liabilities. The scope of
the functions in this package is limited to expenditures. Income, for
example, is imputed and calculation of income means goes through a different
process than do expenditure means. Please see
\href{https://www.bls.gov/cex/csxguide.pdf}{User's Guide to Income Imputation in the CE}
}
\examples{
\dontrun{
# 'survey' can be entered as a string
ce_hg(2016, "integrated", "hg-files.zip")

# 'survey' can also be entered as a symbol
ce_hg(2016, integrated, "hg-files.zip")
}
}
