% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_epidemic_onset.R
\name{calc_epidemic_onset}
\alias{calc_epidemic_onset}
\title{Calculate epidemic onset}
\usage{
calc_epidemic_onset(start, end, c_closure, weather, cultivar_sus = 5)
}
\arguments{
\item{start}{POSIXct, start date in which to begin calculating the epidemic
onset, if not specified, the first date in the weather data will be used.}

\item{end}{POSIXct, end date, last date to complete calculating the epidemic
onset, if not specified, the last date in the weather data will be used.}

\item{c_closure}{POSIXct formatted date to start the model running the model
This is usually at canopy closure (Wolf)}

\item{weather}{data.table, formatted with \code{\link{format_weather}}}

\item{cultivar_sus}{numeric, susceptibility of the cultivar on the 'bsa'
https://www.bundessortenamt.de variety list.
Susceptibility rating must range between 1 and 9.
1 = resistant, 9 = susceptible. Default is 5.}
}
\value{
If the input weather is conducive for epidemic, the
function returns a POSIX_ct date when epidemic commences. If no epidemic
occurs, a numeric, proportion indicating the progress an epidemic is returned
}
\description{
Calculate epidemic onset
}
\examples{
wethr <- read.csv(system.file("extdata", "clean_weather.csv",
                  package = "cercospoRa"))
wethr <- format_weather(wethr,time_zone = "UTC")

calc_epidemic_onset(start = as.POSIXct("2022-04-25",tz = "UTC"),
                    end = as.POSIXct("2022-09-30",tz = "UTC"),
                    c_closure = as.POSIXct("2022-07-01",tz = "UTC"),
                    weather = wethr)
}
