% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_samples.R
\name{select_sample}
\alias{select_sample}
\title{Select Subset of Rows}
\usage{
select_sample(data, n = 100, seed = 1313)
}
\arguments{
\item{data}{set of observations. Profile will be calculated for every observation (every row)}

\item{n}{named list of vectors. Elements of the list are vectors with points in which profiles should be calculated. See an example for more details.}

\item{seed}{seed for random number generator.}
}
\value{
a data frame with selected rows
}
\description{
This function selects subset of rows from data set.
This is useful if data is large and we need just a sample to calculate profiles.
}
\details{
Note that \code{select_subsample} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
\examples{
library("DALEX")
small_apartments <- select_sample(apartmentsTest)
head(small_apartments)
}
